/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.pack;

import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.metadata.pack.PackFormat;

final class PackFormatImpl
implements PackFormat {
    private final int format;
    private final int min;
    private final int max;

    PackFormatImpl(int format, int min, int max) {
        this.format = format;
        this.min = min;
        this.max = max;
        if (min > max) {
            throw new IllegalArgumentException("Minimum " + min + " is greater than maximum " + max);
        }
        if (!this.isInRange(format)) {
            throw new IllegalArgumentException("Format " + format + " is not in the range [" + min + ", " + max + "]");
        }
    }

    @Override
    public int format() {
        return this.format;
    }

    @Override
    public int min() {
        return this.min;
    }

    @Override
    public int max() {
        return this.max;
    }

    @Override
    public boolean isSingle() {
        return this.min == this.max;
    }

    @Override
    public boolean isInRange(int format) {
        return format >= this.min && format <= this.max;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"format", (int)this.format), ExaminableProperty.of((String)"min", (int)this.min), ExaminableProperty.of((String)"max", (int)this.max));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackFormatImpl that = (PackFormatImpl)o;
        if (this.format != that.format) {
            return false;
        }
        if (this.min != that.min) {
            return false;
        }
        return this.max == that.max;
    }

    public int hashCode() {
        int result = this.format;
        result = 31 * result + this.min;
        result = 31 * result + this.max;
        return result;
    }
}

