/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.language;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.metadata.MetadataPart;
import team.unnamed.creative.metadata.language.LanguageEntry;
import team.unnamed.creative.metadata.language.LanguageMeta;
import team.unnamed.creative.util.MoreCollections;

final class LanguageMetaImpl
implements LanguageMeta {
    private final Map<String, LanguageEntry> languages;

    LanguageMetaImpl(@NotNull Map<String, LanguageEntry> languages) {
        this.languages = MoreCollections.immutableMapOf(Objects.requireNonNull(languages, "languages"));
        this.validate();
    }

    private void validate() {
        for (Map.Entry<String, LanguageEntry> language : this.languages.entrySet()) {
            String code = language.getKey();
            Objects.requireNonNull(code, "Language code is null");
            Objects.requireNonNull(language.getValue(), "Language entry for " + code + " is null");
            if (code.length() <= 16) continue;
            throw new IllegalArgumentException("Language code is more than 16 characters long");
        }
    }

    @Override
    @NotNull
    public Class<? extends MetadataPart> type() {
        return LanguageMeta.class;
    }

    @Override
    @NotNull
    public @Unmodifiable Map<String, LanguageEntry> languages() {
        return this.languages;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"languages", this.languages));
    }

    @NotNull
    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageMetaImpl that = (LanguageMetaImpl)o;
        return this.languages.equals(that.languages);
    }

    public int hashCode() {
        return Objects.hash(this.languages);
    }
}

