/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.gui;

import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.metadata.gui.GuiBorder;
import team.unnamed.creative.metadata.gui.NineSliceGuiScaling;

final class NineSliceGuiScalingImpl
implements NineSliceGuiScaling {
    private final int width;
    private final int height;
    private final GuiBorder border;

    NineSliceGuiScalingImpl(int width, int height, @NotNull GuiBorder border) {
        this.width = width;
        this.height = height;
        this.border = Objects.requireNonNull(border, "border");
        this.validate();
    }

    private void validate() {
        if (this.width <= 0) {
            throw new IllegalArgumentException("Width must be positive! Got " + this.width);
        }
        if (this.height <= 0) {
            throw new IllegalArgumentException("Height must be positive! Got " + this.height);
        }
        if (this.border.left() + this.border.right() >= this.width) {
            throw new IllegalArgumentException("Horizontal borders too big: " + this.border.left() + " + " + this.border.right() + " >= " + this.width);
        }
        if (this.border.top() + this.border.bottom() >= this.height) {
            throw new IllegalArgumentException("Vertical borders too big: " + this.border.top() + " + " + this.border.bottom() + " >= " + this.height);
        }
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    @NotNull
    public GuiBorder border() {
        return this.border;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"width", (int)this.width), ExaminableProperty.of((String)"height", (int)this.height), ExaminableProperty.of((String)"border", (Object)this.border));
    }

    @NotNull
    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NineSliceGuiScalingImpl that = (NineSliceGuiScalingImpl)o;
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        return this.border.equals(that.border);
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.border.hashCode();
        return result;
    }
}

