/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.gui;

import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.metadata.gui.GuiBorder;

final class GuiBorderImpl
implements GuiBorder {
    private final int top;
    private final int bottom;
    private final int left;
    private final int right;

    GuiBorderImpl(int top, int bottom, int left, int right) {
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
        this.validate();
    }

    private void validate() {
        if (this.top < 0) {
            throw new IllegalArgumentException("top border size must be greater than or equal to 0, got " + this.top);
        }
        if (this.bottom < 0) {
            throw new IllegalArgumentException("bottom border size must be greater than or equal to 0, got " + this.bottom);
        }
        if (this.left < 0) {
            throw new IllegalArgumentException("left border size must be greater than or equal to 0, got " + this.left);
        }
        if (this.right < 0) {
            throw new IllegalArgumentException("right border size must be greater than or equal to 0, got " + this.right);
        }
    }

    @Override
    public int top() {
        return this.top;
    }

    @Override
    public int bottom() {
        return this.bottom;
    }

    @Override
    public int left() {
        return this.left;
    }

    @Override
    public int right() {
        return this.right;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"top", (int)this.top), ExaminableProperty.of((String)"bottom", (int)this.bottom), ExaminableProperty.of((String)"left", (int)this.left), ExaminableProperty.of((String)"right", (int)this.right));
    }

    @NotNull
    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GuiBorderImpl)) {
            return false;
        }
        GuiBorderImpl guiBorder = (GuiBorderImpl)o;
        return this.top == guiBorder.top && this.bottom == guiBorder.bottom && this.left == guiBorder.left && this.right == guiBorder.right;
    }

    public int hashCode() {
        return Objects.hash(this.top, this.bottom, this.left, this.right);
    }
}

