/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.metadata.Metadata;
import team.unnamed.creative.metadata.MetadataPart;
import team.unnamed.creative.util.MoreCollections;

final class MetadataImpl
implements Metadata {
    static final Metadata EMPTY = new MetadataImpl(Collections.emptyMap());
    private final Map<Class<?>, MetadataPart> parts;

    MetadataImpl(@NotNull Map<Class<?>, MetadataPart> parts) {
        this.parts = MoreCollections.immutableMapOf(Objects.requireNonNull(parts, "parts"));
    }

    @Override
    public @Unmodifiable @NotNull Collection<MetadataPart> parts() {
        return this.parts.values();
    }

    @Override
    @Nullable
    public <T extends MetadataPart> T meta(@NotNull Class<T> type) {
        MetadataPart metadataPart = this.parts.get(type);
        if (metadataPart == null) {
            return null;
        }
        return (T)((MetadataPart)type.cast(metadataPart));
    }

    @Override
    @NotNull
    public Metadata.Builder toBuilder() {
        Metadata.Builder builder = Metadata.metadata();
        for (Map.Entry<Class<?>, MetadataPart> entry : this.parts.entrySet()) {
            builder.addPart(entry.getValue());
        }
        return builder;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"parts", this.parts));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataImpl metadata = (MetadataImpl)o;
        return this.parts.equals(metadata.parts);
    }

    public int hashCode() {
        return Objects.hash(this.parts);
    }

    static final class BuilderImpl
    implements Metadata.Builder {
        private final Map<Class<?>, MetadataPart> parts = new LinkedHashMap();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public Metadata.Builder parts(@NotNull Collection<MetadataPart> parts) {
            Objects.requireNonNull(parts, "parts");
            this.parts.clear();
            for (MetadataPart part : parts) {
                this.parts.put(part.type(), part);
            }
            return this;
        }

        @Override
        @NotNull
        public Metadata.Builder addPart(@NotNull MetadataPart part) {
            Objects.requireNonNull(part, "part");
            this.parts.put(part.type(), part);
            return this;
        }

        @Override
        @NotNull
        public Metadata build() {
            return new MetadataImpl(this.parts);
        }
    }
}

