/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.lang;

import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.translation.Translatable;
import net.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.lang.LanguageImpl;
import team.unnamed.creative.overlay.ResourceContainer;
import team.unnamed.creative.part.ResourcePackPart;

@ApiStatus.NonExtendable
public interface Language
extends ResourcePackPart,
Keyed,
Examinable {
    @NotNull
    public static Language language(@NotNull Key key, @NotNull Map<String, String> translations) {
        return new LanguageImpl(key, translations);
    }

    @NotNull
    public static Builder language() {
        return new LanguageImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Language of(@NotNull Key key, @NotNull Map<String, String> translations) {
        return new LanguageImpl(key, translations);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Builder builder() {
        return new LanguageImpl.BuilderImpl();
    }

    @NotNull
    public Key key();

    @NotNull
    public Map<String, String> translations();

    @Nullable
    default public String translation(@NotNull String key) {
        Objects.requireNonNull(key, "key");
        return this.translations().get(key);
    }

    @Nullable
    default public String translation(@NotNull Translatable translatable) {
        Objects.requireNonNull(translatable, "translatable");
        return this.translation(translatable.translationKey());
    }

    @Override
    default public void addTo(@NotNull ResourceContainer resourceContainer) {
        resourceContainer.language(this);
    }

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull Key var1);

        @NotNull
        public Builder translations(@NotNull Map<String, String> var1);

        @NotNull
        public Builder translation(@NotNull String var1, @NotNull String var2);

        @NotNull
        public Language build();
    }
}

