/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.font;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.font.UnihexFontProvider;
import team.unnamed.creative.util.MoreCollections;

final class UnihexFontProviderImpl
implements UnihexFontProvider {
    private final Key file;
    private final List<UnihexFontProvider.SizeOverride> sizes;

    UnihexFontProviderImpl(@NotNull Key file, @NotNull List<UnihexFontProvider.SizeOverride> sizes) {
        this.file = Objects.requireNonNull(file, "file");
        this.sizes = MoreCollections.immutableListOf(Objects.requireNonNull(sizes, "sizes"));
    }

    @Override
    @NotNull
    public Key file() {
        return this.file;
    }

    @Override
    public @Unmodifiable @NotNull List<UnihexFontProvider.SizeOverride> sizes() {
        return this.sizes;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"file", (Object)this.file), ExaminableProperty.of((String)"sizes", this.sizes));
    }

    @NotNull
    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnihexFontProviderImpl that = (UnihexFontProviderImpl)o;
        if (!this.file.equals(that.file)) {
            return false;
        }
        return this.sizes.equals(that.sizes);
    }

    public int hashCode() {
        int result = this.file.hashCode();
        result = 31 * result + this.sizes.hashCode();
        return result;
    }

    static final class BuilderImpl
    implements UnihexFontProvider.Builder {
        private Key file;
        private List<UnihexFontProvider.SizeOverride> sizes = new ArrayList<UnihexFontProvider.SizeOverride>();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public UnihexFontProvider.Builder file(@NotNull Key file) {
            this.file = Objects.requireNonNull(file, "file");
            return this;
        }

        @Override
        @NotNull
        public UnihexFontProvider.Builder sizes(@NotNull List<UnihexFontProvider.SizeOverride> sizes) {
            Objects.requireNonNull(sizes, "sizes");
            this.sizes = new ArrayList<UnihexFontProvider.SizeOverride>(sizes);
            return this;
        }

        @Override
        @NotNull
        public UnihexFontProvider.Builder addSize(@NotNull UnihexFontProvider.SizeOverride size) {
            Objects.requireNonNull(size, "size");
            this.sizes.add(size);
            return this;
        }

        @Override
        @NotNull
        public UnihexFontProvider build() {
            return new UnihexFontProviderImpl(this.file, this.sizes);
        }
    }

    static final class SizeOverrideImpl
    implements UnihexFontProvider.SizeOverride {
        private final int from;
        private final int to;
        private final int left;
        private final int right;

        SizeOverrideImpl(int from, int to, int left, int right) {
            this.from = from;
            this.to = to;
            this.left = left;
            this.right = right;
            this.validate();
        }

        SizeOverrideImpl(String from, String to, int left, int right) {
            this.left = left;
            this.right = right;
            int[] fromCodepoints = from.codePoints().toArray();
            if (fromCodepoints.length != 1) {
                throw new IllegalArgumentException("Only one codepoint is allowed for 'from' parameter, got " + fromCodepoints.length + " (" + from + ")");
            }
            this.from = fromCodepoints[0];
            int[] toCodepoints = to.codePoints().toArray();
            if (toCodepoints.length != 1) {
                throw new IllegalArgumentException("Only one codepoint is allowed for 'to' parameter, got " + toCodepoints.length + " (" + to + ")");
            }
            this.to = toCodepoints[0];
            this.validate();
        }

        private void validate() {
            if (this.from >= this.to) {
                throw new IllegalArgumentException("Invalid range: [" + this.from + ";" + this.to + "]");
            }
        }

        @Override
        public int from() {
            return this.from;
        }

        @Override
        public int to() {
            return this.to;
        }

        @Override
        public int left() {
            return this.left;
        }

        @Override
        public int right() {
            return this.right;
        }

        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of((String)"from", (int)this.from), ExaminableProperty.of((String)"to", (int)this.to), ExaminableProperty.of((String)"left", (int)this.left), ExaminableProperty.of((String)"right", (int)this.right));
        }

        @NotNull
        public String toString() {
            return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SizeOverrideImpl override = (SizeOverrideImpl)o;
            if (this.from != override.from) {
                return false;
            }
            if (this.to != override.to) {
                return false;
            }
            if (this.left != override.left) {
                return false;
            }
            return this.right == override.right;
        }

        public int hashCode() {
            int result = this.from;
            result = 31 * result + this.to;
            result = 31 * result + this.left;
            result = 31 * result + this.right;
            return result;
        }
    }
}

