/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.font;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.base.Vector2Float;
import team.unnamed.creative.font.FontProvider;
import team.unnamed.creative.util.MoreCollections;

public class TrueTypeFontProvider
implements FontProvider {
    public static final float DEFAULT_SIZE = 11.0f;
    public static final float DEFAULT_OVERSAMPLE = 1.0f;
    private final Key file;
    private final Vector2Float shift;
    private final float size;
    private final float oversample;
    private final @Unmodifiable List<String> skip;

    protected TrueTypeFontProvider(Key file, Vector2Float shift, float size, float oversample, List<String> skip) {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(shift, "shift");
        Objects.requireNonNull(skip, "skip");
        this.file = file;
        this.shift = shift;
        this.size = size;
        this.oversample = oversample;
        this.skip = MoreCollections.immutableListOf(skip);
    }

    public Key file() {
        return this.file;
    }

    public Vector2Float shift() {
        return this.shift;
    }

    public float size() {
        return this.size;
    }

    public float oversample() {
        return this.oversample;
    }

    public @Unmodifiable List<String> skip() {
        return this.skip;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"file", (Object)this.file), ExaminableProperty.of((String)"shift", (Object)this.shift), ExaminableProperty.of((String)"size", (float)this.size), ExaminableProperty.of((String)"oversample", (float)this.oversample), ExaminableProperty.of((String)"skip", this.skip));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrueTypeFontProvider that = (TrueTypeFontProvider)o;
        return Float.compare(that.size, this.size) == 0 && Float.compare(that.oversample, this.oversample) == 0 && this.file.equals(that.file) && this.shift.equals(that.shift) && this.skip.equals(that.skip);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.shift, Float.valueOf(this.size), Float.valueOf(this.oversample), this.skip);
    }

    public static class Builder {
        private Key file;
        private Vector2Float shift = Vector2Float.ZERO;
        private float size = 11.0f;
        private float oversample = 1.0f;
        private List<String> skip = Collections.emptyList();

        protected Builder() {
        }

        public Builder file(Key file) {
            this.file = Objects.requireNonNull(file, "file");
            return this;
        }

        public Builder shift(Vector2Float shift) {
            this.shift = Objects.requireNonNull(shift, "shift");
            return this;
        }

        public Builder size(float size) {
            this.size = size;
            return this;
        }

        public Builder oversample(float oversample) {
            this.oversample = oversample;
            return this;
        }

        public Builder skip(List<String> skip) {
            this.skip = Objects.requireNonNull(skip, "skip");
            return this;
        }

        public Builder skip(String ... skip) {
            Objects.requireNonNull(skip, "skip");
            this.skip = Arrays.asList(skip);
            return this;
        }

        public TrueTypeFontProvider build() {
            return new TrueTypeFontProvider(this.file, this.shift, this.size, this.oversample, this.skip);
        }
    }
}

