/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.font;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.font.FontProvider;
import team.unnamed.creative.util.MoreCollections;

public class SpaceFontProvider
implements FontProvider {
    private final Map<String, Integer> advances;

    protected SpaceFontProvider(Map<String, Integer> advances) {
        Objects.requireNonNull(advances, "advances");
        this.advances = MoreCollections.immutableMapOf(advances);
        this.validate();
    }

    private void validate() {
        for (Map.Entry<String, Integer> entry : this.advances.entrySet()) {
            String character = entry.getKey();
            Integer offset = entry.getValue();
            Objects.requireNonNull(character, "A key from the 'advances' map is null");
            Objects.requireNonNull(offset, "The advanced pixels value for '" + character + "' character is null");
        }
    }

    public Map<String, Integer> advances() {
        return this.advances;
    }

    public SpaceFontProvider advances(Map<String, Integer> advances) {
        return this.toBuilder().advances(advances).build();
    }

    public Builder toBuilder() {
        return FontProvider.space().advances(this.advances);
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"advances", this.advances));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceFontProvider that = (SpaceFontProvider)o;
        return this.advances.equals(that.advances);
    }

    public int hashCode() {
        return Objects.hash(this.advances);
    }

    public static class Builder {
        private Map<String, Integer> advances;

        protected Builder() {
        }

        public Builder advances(Map<String, Integer> entries) {
            Objects.requireNonNull(entries, "entries");
            this.advances = entries;
            return this;
        }

        public Builder advance(String character, int value) {
            if (this.advances == null) {
                this.advances = new LinkedHashMap<String, Integer>();
            }
            this.advances.put(character, value);
            return this;
        }

        public Builder advance(int codePoint, int value) {
            return this.advance(new StringBuilder().appendCodePoint(codePoint).toString(), value);
        }

        public SpaceFontProvider build() {
            return new SpaceFontProvider(this.advances);
        }
    }
}

