/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.font;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.font.Font;
import team.unnamed.creative.font.FontProvider;

final class FontImpl
implements Font {
    private final Key key;
    private final List<FontProvider> providers;

    FontImpl(@NotNull Key key, @NotNull List<FontProvider> providers) {
        this.key = Objects.requireNonNull(key, "key");
        this.providers = Objects.requireNonNull(providers, "providers");
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    @NotNull
    public Font key(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return new FontImpl(key, this.providers);
    }

    @Override
    @NotNull
    public List<FontProvider> providers() {
        return this.providers;
    }

    @Override
    @NotNull
    public Font providers(@NotNull List<FontProvider> providers) {
        Objects.requireNonNull(providers, "providers");
        return new FontImpl(this.key, providers);
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"key", (Object)this.key), ExaminableProperty.of((String)"providers", this.providers));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontImpl that = (FontImpl)o;
        return this.key.equals(that.key) && this.providers.equals(that.providers);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.providers);
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    static final class BuilderImpl
    implements Font.Builder {
        private Key key;
        private List<FontProvider> providers;

        BuilderImpl() {
        }

        @Override
        @NotNull
        public Font.Builder key(@NotNull Key key) {
            this.key = Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        @NotNull
        public Font.Builder providers(@NotNull List<FontProvider> providers) {
            this.providers = new ArrayList<FontProvider>((Collection)Objects.requireNonNull(providers, "providers"));
            return this;
        }

        @Override
        @NotNull
        public Font.Builder providers(FontProvider ... providers) {
            return this.providers(Arrays.asList(providers));
        }

        @Override
        @NotNull
        public Font.Builder addProvider(@NotNull FontProvider provider) {
            Objects.requireNonNull(provider, "provider");
            if (this.providers == null) {
                this.providers = new ArrayList<FontProvider>();
            }
            this.providers.add(provider);
            return this;
        }

        @Override
        @NotNull
        public Font build() {
            return new FontImpl(this.key, this.providers);
        }
    }
}

