/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.blockstate;

import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;

public class Variant
implements Examinable {
    public static final int DEFAULT_X_ROTATION = 0;
    public static final int DEFAULT_Y_ROTATION = 0;
    public static final boolean DEFAULT_UV_LOCK = false;
    public static final int DEFAULT_WEIGHT = 1;
    private final Key model;
    private final int x;
    private final int y;
    private final boolean uvLock;
    private final int weight;

    private Variant(Key model, int x, int y, boolean uvLock, int weight) {
        this.model = Objects.requireNonNull(model, "model");
        this.x = x;
        this.y = y;
        this.uvLock = uvLock;
        this.weight = weight;
        this.validate();
    }

    private void validate() {
        if (this.x % 90 != 0 || this.x < 0 || this.x > 270) {
            throw new IllegalArgumentException("X rotation must be a positive multiple of 90");
        }
        if (this.y % 90 != 0 || this.y < 0 || this.y > 270) {
            throw new IllegalArgumentException("Y rotation must be a positive multiple of 90");
        }
        if (this.weight <= 0) {
            throw new IllegalArgumentException("Zero or negative weight");
        }
    }

    public Key model() {
        return this.model;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public boolean uvLock() {
        return this.uvLock;
    }

    public int weight() {
        return this.weight;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"model", (Object)this.model), ExaminableProperty.of((String)"x", (int)this.x), ExaminableProperty.of((String)"y", (int)this.y), ExaminableProperty.of((String)"uvlock", (boolean)this.uvLock), ExaminableProperty.of((String)"weight", (int)this.weight));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variant that = (Variant)o;
        return this.x == that.x && this.y == that.y && this.uvLock == that.uvLock && this.weight == that.weight && this.model.equals(that.model);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.x, this.y, this.uvLock, this.weight);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Key model;
        private int x = 0;
        private int y = 0;
        private boolean uvLock = false;
        private int weight = 1;

        private Builder() {
        }

        public Builder model(Key model) {
            this.model = Objects.requireNonNull(model, "model");
            return this;
        }

        public Builder x(int x) {
            this.x = x;
            return this;
        }

        public Builder y(int y) {
            this.y = y;
            return this;
        }

        public Builder uvLock(boolean uvLock) {
            this.uvLock = uvLock;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Variant build() {
            return new Variant(this.model, this.x, this.y, this.uvLock, this.weight);
        }
    }
}

