/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.blockstate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public interface Condition
extends Examinable {
    public static final Condition NONE = new Condition(){

        public String toString() {
            return "Condition.NONE";
        }
    };

    public static Condition and(Condition ... conditions) {
        return new And(Arrays.asList(conditions));
    }

    public static Condition and(List<Condition> conditions) {
        return new And(new ArrayList<Condition>(conditions));
    }

    public static Condition or(Condition ... conditions) {
        return new Or(Arrays.asList(conditions));
    }

    public static Condition or(List<Condition> conditions) {
        return new Or(new ArrayList<Condition>(conditions));
    }

    public static Condition match(String key, Object value) {
        return new Match(key, value);
    }

    public static class Match
    implements Condition {
        private final String key;
        private final Object value;

        private Match(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public Object value() {
            return this.value;
        }

        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of((String)"key", (String)this.key), ExaminableProperty.of((String)"value", (Object)this.value));
        }
    }

    public static class Or
    implements Condition {
        private final List<Condition> conditions;

        private Or(List<Condition> conditions) {
            this.conditions = conditions;
        }

        public List<Condition> conditions() {
            return this.conditions;
        }

        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of((String)"conditions", this.conditions));
        }
    }

    public static class And
    implements Condition {
        private final List<Condition> conditions;

        private And(List<Condition> conditions) {
            this.conditions = conditions;
        }

        public List<Condition> conditions() {
            return this.conditions;
        }

        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of((String)"conditions", this.conditions));
        }
    }
}

