/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.base;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.base.Axis3D;

public final class Vector3Float
implements Examinable,
Iterable<Float> {
    public static final Vector3Float ZERO = new Vector3Float(0.0f, 0.0f, 0.0f);
    public static final Vector3Float ONE = new Vector3Float(1.0f, 1.0f, 1.0f);
    private final float x;
    private final float y;
    private final float z;

    public Vector3Float(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float x() {
        return this.x;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector3Float x(float x) {
        return new Vector3Float(x, this.y, this.z);
    }

    public float y() {
        return this.y;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector3Float y(float y) {
        return new Vector3Float(this.x, y, this.z);
    }

    public float z() {
        return this.z;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector3Float z(float z) {
        return new Vector3Float(this.x, this.y, z);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public Vector3Float add(float x, float y, float z) {
        return new Vector3Float(this.x + x, this.y + y, this.z + z);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector3Float add(@NotNull Vector3Float value) {
        return new Vector3Float(this.x + value.x(), this.y + value.y(), this.z + value.z());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public Vector3Float subtract(float x, float y, float z) {
        return new Vector3Float(this.x - x, this.y - y, this.z - z);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector3Float subtract(@NotNull Vector3Float value) {
        return new Vector3Float(this.x - value.x(), this.y - value.y(), this.z - value.z());
    }

    @NotNull
    public Vector3Float multiply(float value) {
        return new Vector3Float(this.x * value, this.y * value, this.z * value);
    }

    @NotNull
    public Vector3Float multiply(float x, float y, float z) {
        return new Vector3Float(this.x * x, this.y * y, this.z * z);
    }

    @NotNull
    public Vector3Float multiply(@NotNull Vector3Float value) {
        return new Vector3Float(this.x * value.x(), this.y * value.y(), this.z * value.z());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector3Float divide(float value) {
        return new Vector3Float(this.x / value, this.y / value, this.z / value);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public Vector3Float divide(float x, float y, float z) {
        return new Vector3Float(this.x / x, this.y / y, this.z / z);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector3Float divide(@NotNull Vector3Float value) {
        return new Vector3Float(this.x / value.x(), this.y / value.y(), this.z / value.z());
    }

    @Contract(pure=true)
    public float dot(@NotNull Vector3Float vector) {
        return this.x * vector.x() + this.y * vector.y() + this.z * vector.z();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector3Float crossProduct(@NotNull Vector3Float vector) {
        return new Vector3Float(this.y * vector.z - vector.y * this.z, this.z * vector.x - vector.z * this.x, this.x * vector.y - vector.x * this.y);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public Vector3Float with(@NotNull Axis3D axis, float value) {
        float x = this.x;
        float y = this.y;
        float z = this.z;
        switch (axis) {
            case X: {
                x = value;
                break;
            }
            case Y: {
                y = value;
                break;
            }
            case Z: {
                z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid axis: " + (Object)((Object)axis));
            }
        }
        return new Vector3Float(x, y, z);
    }

    public float get(@NotNull Axis3D axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + (Object)((Object)axis));
    }

    public float @NotNull [] toArray() {
        return new float[]{this.x, this.y, this.z};
    }

    @Override
    @NotNull
    public Iterator<Float> iterator() {
        return Arrays.asList(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z)).iterator();
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"x", (float)this.x), ExaminableProperty.of((String)"y", (float)this.y), ExaminableProperty.of((String)"z", (float)this.z));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector3Float that = (Vector3Float)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

