/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.atlas;

import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.atlas.DirectoryAtlasSource;
import team.unnamed.creative.atlas.DirectoryAtlasSourceImpl;
import team.unnamed.creative.atlas.FilterAtlasSource;
import team.unnamed.creative.atlas.FilterAtlasSourceImpl;
import team.unnamed.creative.atlas.PalettedPermutationsAtlasSource;
import team.unnamed.creative.atlas.PalettedPermutationsAtlasSourceImpl;
import team.unnamed.creative.atlas.SingleAtlasSource;
import team.unnamed.creative.atlas.SingleAtlasSourceImpl;
import team.unnamed.creative.atlas.UnstitchAtlasSource;
import team.unnamed.creative.atlas.UnstitchAtlasSourceImpl;
import team.unnamed.creative.base.KeyPattern;
import team.unnamed.creative.base.Vector2Float;

@ApiStatus.NonExtendable
public interface AtlasSource
extends Examinable {
    @NotNull
    public static SingleAtlasSource single(@NotNull Key resource, @Nullable Key sprite) {
        return new SingleAtlasSourceImpl(resource, sprite);
    }

    @NotNull
    public static SingleAtlasSource single(@NotNull Key resource) {
        return AtlasSource.single(resource, null);
    }

    @NotNull
    public static DirectoryAtlasSource directory(@NotNull String source, @NotNull String prefix) {
        return new DirectoryAtlasSourceImpl(source, prefix);
    }

    @NotNull
    public static FilterAtlasSource filter(@NotNull KeyPattern pattern) {
        return new FilterAtlasSourceImpl(pattern);
    }

    @NotNull
    public static UnstitchAtlasSource unstitch(@NotNull Key resource, @NotNull List<UnstitchAtlasSource.Region> regions, @NotNull Vector2Float divisor) {
        return new UnstitchAtlasSourceImpl(resource, regions, divisor);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static UnstitchAtlasSource unstitch(@NotNull Key resource, @NotNull List<UnstitchAtlasSource.Region> regions, double xDivisor, double yDivisor) {
        return AtlasSource.unstitch(resource, regions, new Vector2Float((float)xDivisor, (float)yDivisor));
    }

    @NotNull
    public static PalettedPermutationsAtlasSource palettedPermutations(@NotNull List<Key> textures, @NotNull Key paletteKey, @NotNull Map<String, Key> permutations) {
        return new PalettedPermutationsAtlasSourceImpl(textures, paletteKey, permutations);
    }
}

