/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.ResourcePack;
import team.unnamed.creative.base.Writable;
import team.unnamed.creative.metadata.Metadata;
import team.unnamed.creative.metadata.MetadataPart;
import team.unnamed.creative.metadata.overlays.OverlayEntry;
import team.unnamed.creative.overlay.Overlay;
import team.unnamed.creative.overlay.ResourceContainer;
import team.unnamed.creative.overlay.ResourceContainerImpl;
import team.unnamed.creative.resources.MergeStrategy;

final class ResourcePackImpl
extends ResourceContainerImpl
implements ResourcePack {
    private final Map<String, Overlay> overlays = new LinkedHashMap<String, Overlay>();
    @Nullable
    private Writable icon;
    private Metadata metadata;

    ResourcePackImpl() {
    }

    @Override
    @Nullable
    public Writable icon() {
        return this.icon;
    }

    @Override
    public void icon(@Nullable Writable icon) {
        this.icon = icon;
    }

    @Override
    @NotNull
    public Metadata metadata() {
        return this.metadata == null ? Metadata.empty() : this.metadata;
    }

    @Override
    public void metadata(@NotNull Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata");
        this.metadata = metadata;
    }

    @Override
    public void overlay(@NotNull Overlay overlay) {
        Objects.requireNonNull(overlay, "overlay");
        this.overlays.put(overlay.directory(), overlay);
    }

    @Override
    @Nullable
    public Overlay overlay(@NotNull @OverlayEntry.Directory String directory) {
        Objects.requireNonNull(directory, "directory");
        return this.overlays.get(directory);
    }

    @Override
    @NotNull
    public Collection<Overlay> overlays() {
        return this.overlays.values();
    }

    @Override
    public void merge(@NotNull ResourceContainer other, @NotNull MergeStrategy strategy) {
        super.merge(other, strategy);
        if (!(other instanceof ResourcePack)) {
            return;
        }
        ResourcePack otherPack = (ResourcePack)other;
        Writable newIcon = otherPack.icon();
        if (strategy == MergeStrategy.override()) {
            if (newIcon != null) {
                this.icon = newIcon;
            }
        } else if (strategy == MergeStrategy.mergeAndFailOnError()) {
            if (newIcon != null && this.icon != null) {
                throw new IllegalStateException("Can't merge resource packs, icons are already set for both packs");
            }
            if (newIcon != null) {
                this.icon = newIcon;
            }
        } else if (strategy == MergeStrategy.mergeAndKeepFirstOnError() && this.icon == null && newIcon != null) {
            this.icon = newIcon;
        }
        Metadata newMetadata = otherPack.metadata();
        if (this.metadata == null || strategy == MergeStrategy.override()) {
            this.metadata = newMetadata;
        } else {
            HashSet<MetadataPart> oldParts = new HashSet<MetadataPart>(this.metadata.parts());
            for (MetadataPart part : newMetadata.parts()) {
                boolean duplicate = false;
                for (MetadataPart oldPart : oldParts) {
                    if (oldPart.type() != part.type()) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate && strategy == MergeStrategy.mergeAndFailOnError()) {
                    throw new IllegalStateException("Can't merge resource packs, metadata part of type " + part.type().getSimpleName() + " is already set for both packs");
                }
                oldParts.add(part);
            }
            this.metadata = Metadata.metadata().parts(oldParts).build();
        }
        for (Overlay overlay : otherPack.overlays()) {
            Overlay existingOverlay = this.overlays.get(overlay.directory());
            if (existingOverlay == null) {
                this.overlays.put(overlay.directory(), overlay);
                continue;
            }
            existingOverlay.merge(overlay, strategy);
        }
    }
}

