/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.util.actions.components.implementations;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.SplittableRandom;
import me.gabytm.util.actions.actions.Context;
import me.gabytm.util.actions.components.Component;
import me.gabytm.util.actions.placeholders.PlaceholderManager;
import me.gabytm.util.actions.utils.Numbers;
import org.jetbrains.annotations.NotNull;

public class RandomDoubleComponent<T>
extends Component<T, Double> {
    private static final SplittableRandom RANDOM = new SplittableRandom();
    public static final String ID = "random";
    private final String minString;
    private final String maxString;
    private final Double minDouble;
    private final Double maxDouble;
    private final int precision;

    public RandomDoubleComponent(@NotNull String stringValue, @NotNull PlaceholderManager placeholderManager) {
        super(stringValue, placeholderManager);
        String[] parts = stringValue.split(",");
        if (parts.length == 3) {
            this.precision = Numbers.tryParse(parts[0], -1);
            this.minString = parts[1];
            this.maxString = parts[2];
        } else {
            this.precision = -1;
            this.minString = parts[0];
            this.maxString = parts[1];
        }
        this.minDouble = Numbers.tryParseDouble(this.minString);
        this.maxDouble = Numbers.tryParseDouble(this.maxString);
    }

    @Override
    @NotNull
    public Double parse(@NotNull T t, @NotNull Context<T> context) {
        double max;
        double min;
        double result = this.minDouble != null && this.maxDouble != null ? (this.minDouble.equals(this.maxDouble) ? this.minDouble.doubleValue() : RANDOM.nextDouble(this.minDouble, this.maxDouble + 1.0)) : ((min = Numbers.tryParse(this.placeholderManager.replace(t, this.minString, context), 0.0)) == (max = Numbers.tryParse(this.placeholderManager.replace(t, this.maxString, context), 0.0)) ? min : RANDOM.nextDouble(min, max + 1.0));
        return this.precision < 0 ? result : BigDecimal.valueOf(result).setScale(this.precision, RoundingMode.HALF_UP).doubleValue();
    }
}

