/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.protectionlib.compatibilities;

import io.th0rgal.protectionlib.ProtectionCompatibility;
import net.william278.husktowns.api.BukkitHuskTownsAPI;
import net.william278.husktowns.api.HuskTownsAPI;
import net.william278.husktowns.claim.Position;
import net.william278.husktowns.libraries.cloplib.operation.OperationType;
import net.william278.husktowns.user.OnlineUser;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class HuskTownsCompat
extends ProtectionCompatibility {
    private final HuskTownsAPI commonAPI = HuskTownsAPI.getInstance();
    private final BukkitHuskTownsAPI bukkitAPI = BukkitHuskTownsAPI.getInstance();

    public HuskTownsCompat(JavaPlugin mainPlugin, Plugin plugin) {
        super(mainPlugin, plugin);
    }

    @Override
    public boolean canBuild(Player player, Location target) {
        return this.isOperationAllowed(player, target, OperationType.BLOCK_PLACE);
    }

    @Override
    public boolean canBreak(Player player, Location target) {
        return this.isOperationAllowed(player, target, OperationType.BLOCK_BREAK);
    }

    @Override
    public boolean canInteract(Player player, Location target) {
        OperationType type = target.getBlock().getType().isBlock() ? OperationType.BLOCK_INTERACT : OperationType.ENTITY_INTERACT;
        return this.isOperationAllowed(player, target, type);
    }

    @Override
    public boolean canUse(Player player, Location target) {
        return this.isOperationAllowed(player, target, OperationType.BLOCK_INTERACT);
    }

    private boolean isOperationAllowed(@NotNull Player player, @NotNull Location location, @NotNull OperationType type) {
        OnlineUser user = this.bukkitAPI.getOnlineUser(player);
        Position position = this.bukkitAPI.getPosition(location);
        return this.commonAPI.isOperationAllowed(user, type, position);
    }
}

