/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.protectionlib.compatibilities;

import io.th0rgal.protectionlib.ProtectionCompatibility;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GriefPreventionCompat
extends ProtectionCompatibility {
    public GriefPreventionCompat(JavaPlugin mainPlugin, Plugin plugin) {
        super(mainPlugin, plugin);
    }

    @Override
    public boolean canBuild(Player player, Location target) {
        return this.checkPermission(player, target, ClaimPermission.Build);
    }

    @Override
    public boolean canBreak(Player player, Location target) {
        return this.checkPermission(player, target, ClaimPermission.Build);
    }

    @Override
    public boolean canInteract(Player player, Location target) {
        return this.checkPermission(player, target, ClaimPermission.Access);
    }

    @Override
    public boolean canUse(Player player, Location target) {
        return this.checkPermission(player, target, ClaimPermission.Access);
    }

    private boolean checkPermission(Player player, Location target, ClaimPermission permission) {
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(target, false, playerData.lastClaim);
        if (claim == null || playerData.ignoreClaims) {
            return true;
        }
        playerData.lastClaim = claim;
        return claim.checkPermission(player, permission, null) == null;
    }
}

