/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.logs;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.utils.AdventureUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;

public class Logs {
    private Logs() {
    }

    public static void logInfo(String message) {
        if (!message.isEmpty()) {
            Logs.logInfo(message, false);
        }
    }

    public static void logInfo(String message, boolean newline) {
        Component info = AdventureUtils.MINI_MESSAGE.deserialize((Object)("<prefix><#529ced>" + message + "</#529ced>"));
        OraxenPlugin.get().getAudience().console().sendMessage(newline ? info.append((Component)Component.newline()) : info);
    }

    public static void logSuccess(String message) {
        Logs.logSuccess(message, false);
    }

    public static void logSuccess(String message, boolean newline) {
        Component success = AdventureUtils.MINI_MESSAGE.deserialize((Object)("<prefix><#55ffa4>" + message + "</#55ffa4>"));
        OraxenPlugin.get().getAudience().console().sendMessage(newline ? success.append((Component)Component.newline()) : success);
    }

    public static void logError(String message) {
        Logs.logError(message, false);
    }

    public static void logError(String message, boolean newline) {
        Component error = AdventureUtils.MINI_MESSAGE.deserialize((Object)("<prefix><#e73f34>" + message + "</#e73f34>"));
        OraxenPlugin.get().getAudience().console().sendMessage(newline ? error.append((Component)Component.newline()) : error);
    }

    public static void logWarning(String message) {
        Logs.logWarning(message, false);
    }

    public static void logWarning(String message, boolean newline) {
        Component warning = AdventureUtils.MINI_MESSAGE.deserialize((Object)("<prefix><#f9f178>" + message + "</#f9f178>"));
        OraxenPlugin.get().getAudience().console().sendMessage(newline ? warning.append((Component)Component.newline()) : warning);
    }

    public static void newline() {
        OraxenPlugin.get().getAudience().console().sendMessage((Component)Component.empty());
    }

    public static void debug(Object object) {
        if (Settings.DEBUG.toBool().booleanValue()) {
            Bukkit.broadcastMessage((String)String.valueOf(object));
        }
    }

    public static void debug(Object object, String prefix) {
        if (Settings.DEBUG.toBool().booleanValue()) {
            Bukkit.broadcastMessage((String)(prefix + String.valueOf(object)));
        }
    }

    public static <T> T debugVal(T object) {
        if (Settings.DEBUG.toBool().booleanValue()) {
            Bukkit.broadcastMessage((String)String.valueOf(object));
        }
        return object;
    }

    public static <T> T debugVal(T object, String prefix) {
        if (Settings.DEBUG.toBool().booleanValue()) {
            Bukkit.broadcastMessage((String)(prefix + String.valueOf(object)));
        }
        return object;
    }

    public static void debug(Component component) {
        if (Settings.DEBUG.toBool().booleanValue()) {
            OraxenPlugin.get().getAudience().console().sendMessage((Component)(component != null ? component : Component.text((String)"null")));
        }
    }
}

