/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.armorequipevent;

import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.utils.armorequipevent.ArmorListener;
import io.th0rgal.oraxen.utils.armorequipevent.ArmorType;
import io.th0rgal.oraxen.utils.armorequipevent.DispenserArmorListener;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class ArmorEquipEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancel = false;
    private final EquipMethod equipType;
    private final ArmorType type;
    private ItemStack oldArmorPiece;
    private ItemStack newArmorPiece;

    public static void registerListener(JavaPlugin plugin) {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new ArmorListener(ArmorEquipEvent.getBlockedMaterialNames()), (Plugin)plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new DispenserArmorListener(), (Plugin)plugin);
    }

    private static List<String> getBlockedMaterialNames() {
        return Settings.ARMOR_EQUIP_EVENT_BYPASS.toStringList();
    }

    public static ArmorEquipEvent OraxenHatEquipEvent(Player player, ItemStack oldArmorPiece, ItemStack newArmorPiece) {
        return new ArmorEquipEvent(player, EquipMethod.ORAXEN_HAT, ArmorType.HELMET, oldArmorPiece, newArmorPiece);
    }

    public ArmorEquipEvent(Player player, EquipMethod equipType, ArmorType type, ItemStack oldArmorPiece, ItemStack newArmorPiece) {
        super(player);
        this.equipType = equipType;
        this.type = type;
        this.oldArmorPiece = oldArmorPiece;
        this.newArmorPiece = newArmorPiece;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public void setCancelled(boolean cancel) {
        this.cancel = cancel;
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public ArmorType getType() {
        return this.type;
    }

    public ItemStack getOldArmorPiece() {
        if (ArmorListener.isEmpty(this.oldArmorPiece)) {
            return null;
        }
        return this.oldArmorPiece;
    }

    public void setOldArmorPiece(ItemStack oldArmorPiece) {
        this.oldArmorPiece = oldArmorPiece;
    }

    public ItemStack getNewArmorPiece() {
        if (ArmorListener.isEmpty(this.newArmorPiece)) {
            return null;
        }
        return this.newArmorPiece;
    }

    public final void setNewArmorPiece(ItemStack newArmorPiece) {
        this.newArmorPiece = newArmorPiece;
    }

    public EquipMethod getMethod() {
        return this.equipType;
    }

    public static enum EquipMethod {
        SHIFT_CLICK,
        DRAG,
        PICK_DROP,
        HOTBAR,
        HOTBAR_SWAP,
        DISPENSER,
        BROKE,
        DEATH,
        ORAXEN_HAT;

    }
}

