/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.sound;

import io.th0rgal.oraxen.sound.CustomSound;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class SoundManager {
    private final boolean autoGenerate;
    private final Collection<CustomSound> customSounds;
    private final Map<Key, String> songKeys;

    public SoundManager(YamlConfiguration soundConfig) {
        ConfigurationSection soundsSection;
        this.autoGenerate = soundConfig.getBoolean("settings.automatically_generate");
        this.customSounds = new ArrayList<CustomSound>();
        this.songKeys = new HashMap<Key, String>();
        if (this.autoGenerate && (soundsSection = soundConfig.getConfigurationSection("sounds")) != null) {
            for (String soundName : soundsSection.getKeys(false)) {
                ConfigurationSection soundSection = soundsSection.getConfigurationSection(soundName);
                if (soundSection == null) continue;
                CustomSound sound = new CustomSound(soundName, soundSection);
                if (sound.isJukeboxSound()) {
                    this.songKeys.put((Key)NamespacedKey.fromString((String)("oraxen:" + sound.getName())), sound.getSoundId());
                }
                this.customSounds.add(sound);
            }
        }
    }

    public String songKeyToSoundId(Key key) {
        return this.songKeys.getOrDefault(key, key.toString());
    }

    public Collection<CustomSound> getCustomSounds() {
        return new ArrayList<CustomSound>(this.customSounds);
    }

    public Collection<CustomSound> getJukeboxSounds() {
        return this.customSounds.stream().filter(CustomSound::isJukeboxSound).toList();
    }

    public boolean isAutoGenerate() {
        return this.autoGenerate;
    }
}

