/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.backpack;

import com.jeff_media.morepersistentdatatypes.DataType;
import dev.triumphteam.gui.builder.gui.StorageBuilder;
import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.StorageGui;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.provided.misc.backpack.BackpackMechanic;
import io.th0rgal.oraxen.mechanics.provided.misc.backpack.BackpackMechanicFactory;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.InventoryUtils;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;

public class BackpackListener
implements Listener {
    private final BackpackMechanicFactory factory;

    public BackpackListener(BackpackMechanicFactory factory) {
        this.factory = factory;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.isBackpack(event.getPlayer().getInventory().getItemInMainHand())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDisconnect(PlayerQuitEvent event) {
        this.closeBackpack(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        event.setUseItemInHand(Event.Result.ALLOW);
        this.openBackpack(event.getPlayer());
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!this.isBackpack(event.getOffHandItem()) && !this.isBackpack(event.getMainHandItem())) {
            return;
        }
        InventoryHolder inventoryHolder = InventoryUtils.topInventoryForPlayer(player).getHolder();
        if (!(inventoryHolder instanceof StorageGui)) {
            return;
        }
        StorageGui gui = (StorageGui)inventoryHolder;
        gui.close((HumanEntity)player, true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPickupItem(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!(InventoryUtils.topInventoryForPlayer(player).getHolder() instanceof Gui)) {
            return;
        }
        this.closeBackpack(player);
        this.openBackpack(player);
    }

    private StorageGui createGUI(BackpackMechanic mechanic, ItemStack backpack) {
        ItemMeta backpackMeta = backpack.getItemMeta();
        if (!this.isBackpack(backpack) || backpackMeta == null) {
            return null;
        }
        PersistentDataContainer pdc = backpackMeta.getPersistentDataContainer();
        StorageGui gui = ((StorageBuilder)((StorageBuilder)Gui.storage().title(AdventureUtils.MINI_MESSAGE.deserialize((Object)mechanic.getTitle()))).rows(mechanic.getRows())).create();
        gui.disableItemDrop();
        gui.disableItemSwap();
        gui.setPlayerInventoryAction(event -> {
            if (this.isBackpack(event.getCurrentItem()) || this.isBackpack(event.getCursor())) {
                event.setCancelled(true);
            }
        });
        gui.setDefaultClickAction(event -> {
            if (this.isBackpack(event.getCurrentItem()) || this.isBackpack(event.getCursor())) {
                event.setCancelled(true);
            }
        });
        gui.setDragAction(event -> {
            if (this.isBackpack(event.getCursor())) {
                event.setCancelled(true);
            }
        });
        gui.setOutsideClickAction(event -> {
            if (this.isBackpack(event.getCursor())) {
                event.setCancelled(true);
            }
        });
        gui.setOpenGuiAction(event -> {
            Player player = (Player)event.getPlayer();
            ItemStack[] contents = (ItemStack[])pdc.get(BackpackMechanic.BACKPACK_KEY, DataType.ITEM_STACK_ARRAY);
            if (contents != null) {
                gui.getInventory().setContents(contents);
            }
            if (mechanic.hasOpenSound()) {
                player.playSound(player.getLocation(), mechanic.getOpenSound(), mechanic.getVolume(), mechanic.getPitch());
            }
        });
        gui.setCloseGuiAction(event -> {
            Player player = (Player)event.getPlayer();
            pdc.set(BackpackMechanic.BACKPACK_KEY, DataType.ITEM_STACK_ARRAY, (Object)gui.getInventory().getContents());
            backpack.setItemMeta(backpackMeta);
            if (mechanic.hasCloseSound()) {
                player.getWorld().playSound(player.getLocation(), mechanic.getCloseSound(), mechanic.getVolume(), mechanic.getPitch());
            }
        });
        return gui;
    }

    private boolean isBackpack(ItemStack item) {
        return item != null && this.factory.getMechanic(OraxenItems.getIdByItem(item)) != null;
    }

    private void openBackpack(Player player) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        BackpackMechanic mechanic = (BackpackMechanic)this.factory.getMechanic(OraxenItems.getIdByItem(itemInHand));
        StorageGui gui = this.createGUI(mechanic, itemInHand);
        if (gui == null) {
            return;
        }
        gui.open((HumanEntity)player);
    }

    private void closeBackpack(Player player) {
        InventoryHolder holder = InventoryUtils.topInventoryForPlayer(player).getHolder();
        if (!this.isBackpack(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (holder instanceof StorageGui) {
            StorageGui gui = (StorageGui)holder;
            gui.close((HumanEntity)player, true);
        }
    }
}

