/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.furniture;

import com.jeff_media.morepersistentdatatypes.datatypes.serializable.ConfigurationSerializableDataType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class BlockLocation
implements ConfigurationSerializable {
    public static PersistentDataType<byte[], BlockLocation> dataType = new ConfigurationSerializableDataType<BlockLocation>(BlockLocation.class);
    private int x;
    private int y;
    private int z;

    public BlockLocation(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockLocation(Location location) {
        this.x = location.getBlockX();
        this.y = location.getBlockY();
        this.z = location.getBlockZ();
    }

    public BlockLocation(String serializedBlockLocation) {
        String[] values = serializedBlockLocation.split(",");
        this.x = Integer.parseInt(values[0]);
        this.y = Integer.parseInt(values[1]);
        this.z = Integer.parseInt(values[2]);
    }

    public BlockLocation(Map<String, Integer> coordinatesMap) {
        this.x = coordinatesMap.getOrDefault("x", 0);
        this.y = coordinatesMap.getOrDefault("y", 0);
        this.z = coordinatesMap.getOrDefault("z", 0);
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }

    public BlockLocation add(BlockLocation blockLocation) {
        BlockLocation output = new BlockLocation(this.x, this.y, this.z);
        output.x += blockLocation.x;
        output.y += blockLocation.y;
        output.z += blockLocation.z;
        return output;
    }

    public Location add(Location location) {
        return location.clone().add((double)this.x, (double)this.y, (double)this.z);
    }

    public Location toLocation(World world) {
        return new Location(world, (double)this.x, (double)this.y, (double)this.z);
    }

    public BlockLocation groundRotate(float angle) {
        BlockLocation output = new BlockLocation(this.x, this.y, this.z);
        float fixedAngle = 360.0f - angle;
        double radians = Math.toRadians(fixedAngle);
        output.x = (int)Math.round(Math.cos(radians) * (double)this.x - Math.sin(radians) * (double)this.z);
        output.z = (int)Math.round(Math.sin(radians) * (double)this.x - Math.cos(radians) * (double)this.z);
        if (fixedAngle % 180.0f > 1.0f) {
            output.z = -output.z;
        }
        return output;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof BlockLocation)) return false;
        BlockLocation blockLocation = (BlockLocation)obj;
        if (blockLocation.x != this.x) return false;
        if (blockLocation.y != this.y) return false;
        if (blockLocation.z != this.z) return false;
        return true;
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("x", this.x);
        data.put("y", this.y);
        data.put("z", this.z);
        return data;
    }

    @NotNull
    public static BlockLocation deserialize(@NotNull Map<String, Object> args) {
        return new BlockLocation((Integer)args.get("x"), (Integer)args.get("y"), (Integer)args.get("z"));
    }
}

