/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.api.events.furniture;

import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraxenFurnitureInteractEvent
extends Event
implements Cancellable {
    private final FurnitureMechanic mechanic;
    private final Entity baseEntity;
    private final Player player;
    private final Block block;
    private final BlockFace blockFace;
    private final ItemStack itemInHand;
    private final EquipmentSlot hand;
    private boolean isCancelled;
    private static final HandlerList HANDLERS = new HandlerList();

    public OraxenFurnitureInteractEvent(@NotNull FurnitureMechanic mechanic, @NotNull Entity baseEntity, @NotNull Player player, @Nullable ItemStack itemInHand, @NotNull EquipmentSlot hand) {
        this(mechanic, baseEntity, player, itemInHand, hand, null, null);
    }

    public OraxenFurnitureInteractEvent(@NotNull FurnitureMechanic mechanic, @NotNull Entity baseEntity, @NotNull Player player, @Nullable ItemStack itemInHand, @NotNull EquipmentSlot hand, @Nullable Block block, @Nullable BlockFace blockFace) {
        this.player = player;
        this.mechanic = mechanic;
        this.baseEntity = baseEntity;
        this.block = block;
        this.blockFace = blockFace;
        this.itemInHand = itemInHand;
        this.hand = hand;
        this.isCancelled = false;
    }

    @NotNull
    public FurnitureMechanic getMechanic() {
        return this.mechanic;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @NotNull
    public Entity getBaseEntity() {
        return this.baseEntity;
    }

    @Nullable
    public Entity getInteractionEntity() {
        return this.mechanic.getInteractionEntity(this.baseEntity);
    }

    @Nullable
    public BlockFace getBlockFace() {
        return this.blockFace;
    }

    public ItemStack getItemInHand() {
        return this.itemInHand;
    }

    public EquipmentSlot getHand() {
        return this.hand;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancel) {
        this.isCancelled = cancel;
    }

    @NotNull
    public HandlerList getHandlers() {
        return OraxenFurnitureInteractEvent.getHandlerList();
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

