/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_17_0;

import com.github.stefvanschie.inventoryframework.abstraction.EnchantingTableInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_17_0.util.TextHolderUtil;
import java.lang.reflect.Field;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantingTableInventoryImpl
extends EnchantingTableInventory {
    public EnchantingTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 2) {
            throw new IllegalArgumentException("The amount of items for an enchanting table should be 2, but is '" + itemAmount + "'");
        }
        abs serverPlayer = this.getServerPlayer(player);
        ContainerEnchantingTableImpl containerEnchantmentTable = new ContainerEnchantingTableImpl(serverPlayer, items);
        serverPlayer.bV = containerEnchantmentTable;
        int id = containerEnchantmentTable.j;
        os message = TextHolderUtil.toComponent(title);
        serverPlayer.b.a((pk)new rg(id, bnn.m, message));
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        gs nmsItems = gs.a((Object)bqp.b, (Object[])new bqp[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1])});
        abs serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((bkd)serverPlayer);
        this.getPlayerConnection(serverPlayer).a((pk)new qi(containerId, nmsItems));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        qk packet = new qk(-1, -1, bqp.b);
        this.getPlayerConnection(this.getServerPlayer(player)).a((pk)packet);
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull bkd nmsPlayer) {
        return nmsPlayer.bV.j;
    }

    @NotNull
    @Contract(pure=true)
    private acm getPlayerConnection(@NotNull abs serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private abs getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerEnchantingTableImpl
    extends bnb {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field enchantSlotsField;

        public ContainerEnchantingTableImpl(@Nullable abs serverPlayer, ItemStack[] items) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fj());
            this.player = serverPlayer.getBukkitEntity();
            try {
                this.enchantSlotsField = bnb.class.getDeclaredField("n");
                this.enchantSlotsField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            try {
                art input = (art)this.enchantSlotsField.get((Object)this);
                input.a(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
                input.a(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                try {
                    CraftInventoryEnchanting inventory = new CraftInventoryEnchanting((art)this.enchantSlotsField.get((Object)this)){

                        @NotNull
                        @Contract(pure=true)
                        public InventoryHolder getHolder() {
                            return EnchantingTableInventoryImpl.this.inventoryHolder;
                        }
                    };
                    this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (bmj)this);
                }
                catch (IllegalAccessException exception) {
                    exception.printStackTrace();
                }
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable bkd nmsPlayer) {
            return true;
        }

        public void a(art container) {
        }

        public void b(bkd nmsPlayer) {
        }
    }
}

