/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_17_0;

import com.github.stefvanschie.inventoryframework.abstraction.AnvilInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_17_0.util.CustomInventoryUtil;
import com.github.stefvanschie.inventoryframework.nms.v1_17_0.util.TextHolderUtil;
import java.lang.reflect.Field;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilInventoryImpl
extends AnvilInventory {
    public AnvilInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for an anvil should be 3, but is '" + itemAmount + "'");
        }
        abs serverPlayer = this.getServerPlayer(player);
        CraftEventFactory.handleInventoryCloseEvent((bkd)serverPlayer);
        serverPlayer.bV = serverPlayer.bU;
        os message = TextHolderUtil.toComponent(title);
        ContainerAnvilImpl containerAnvil = new ContainerAnvilImpl(serverPlayer, message);
        Inventory inventory = containerAnvil.getBukkitView().getTopInventory();
        inventory.setItem(0, items[0]);
        inventory.setItem(1, items[1]);
        inventory.setItem(2, items[2]);
        int containerId = containerAnvil.getContainerId();
        serverPlayer.b.a((pk)new rg(containerId, bnn.h, message));
        serverPlayer.bV = containerAnvil;
        serverPlayer.a((bmj)containerAnvil);
        return inventory;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        gs<bqp> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        abs serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((bkd)serverPlayer);
        this.getPlayerConnection(serverPlayer).a((pk)new qi(containerId, nmsItems));
    }

    @Override
    public void sendFirstItem(@NotNull Player player, @Nullable ItemStack item) {
        abs serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((bkd)serverPlayer);
        bqp nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        this.getPlayerConnection(serverPlayer).a((pk)new qk(containerId, 0, nmsItem));
    }

    @Override
    public void sendSecondItem(@NotNull Player player, @Nullable ItemStack item) {
        abs serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((bkd)serverPlayer);
        bqp nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        this.getPlayerConnection(serverPlayer).a((pk)new qk(containerId, 1, nmsItem));
    }

    @Override
    public void sendResultItem(@NotNull Player player, @Nullable ItemStack item) {
        this.sendResultItem(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearResultItem(@NotNull Player player) {
        this.sendResultItem(player, bqp.b);
    }

    @Override
    public void setCursor(@NotNull Player player, @NotNull ItemStack item) {
        this.setCursor(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        qk packet = new qk(-1, -1, bqp.b);
        this.getPlayerConnection(this.getServerPlayer(player)).a((pk)packet);
    }

    @Deprecated
    private void setCursor(@NotNull Player player, @NotNull bqp item) {
        this.getPlayerConnection(this.getServerPlayer(player)).a((pk)new qk(-1, -1, item));
    }

    @Deprecated
    private void sendResultItem(@NotNull Player player, @NotNull bqp item) {
        abs serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((bkd)serverPlayer);
        this.getPlayerConnection(serverPlayer).a((pk)new qk(containerId, 2, item));
    }

    @Deprecated
    @Contract(pure=true)
    private int getContainerId(@NotNull bkd nmsPlayer) {
        return nmsPlayer.bV.j;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    private acm getPlayerConnection(@NotNull abs serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private abs getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerAnvilImpl
    extends bml {
        private static final int RESULT_SLOT_INDEX = 2;
        @NotNull
        private final Field synchronizerField;

        public ContainerAnvilImpl(@NotNull abs serverPlayer, os title) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fj(), bmu.a((bwp)serverPlayer.cv(), (gg)new gg(0, 0, 0)));
            this.checkReachable = false;
            this.w.a((int)AnvilInventoryImpl.this.cost);
            this.setTitle(title);
            final boa originalSlot = (boa)this.i.get(2);
            boa newSlot = new boa(originalSlot.c, originalSlot.d, originalSlot.e, originalSlot.f){

                public boolean a(@NotNull bqp stack) {
                    return true;
                }

                public boolean a(@NotNull bkd playerEntity) {
                    return true;
                }

                public void a(@NotNull bkd player, @NotNull bqp stack) {
                    originalSlot.a(player, stack);
                }
            };
            this.i.set(2, (Object)newSlot);
            try {
                this.synchronizerField = bmj.class.getDeclaredField("v");
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException("Unable to access field", exception);
            }
        }

        public void a(@Nullable String name) {
            bmw synchronizer;
            String string = name = name == null ? "" : name;
            if (!name.equals(AnvilInventoryImpl.this.observableText.get())) {
                AnvilInventoryImpl.this.observableText.set(name);
            }
            try {
                this.synchronizerField.setAccessible(true);
                synchronizer = (bmw)this.synchronizerField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException("Unable to access field", exception);
            }
            synchronizer.a((bmj)this, 2, this.a(2).e());
        }

        public void i() {
        }

        public void b(@NotNull bkd nmsPlayer) {
        }

        protected void a(@NotNull bkd player, @NotNull art inventory) {
        }

        protected void a(@NotNull bkd player, @NotNull bqp stack) {
        }

        public int getContainerId() {
            return this.j;
        }
    }
}

