/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skilltype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.abilities.AbilityManager;
import me.leothepro555.skills.abilities.ArbalistBarbedArrow;
import me.leothepro555.skills.abilities.ArbalistDualArrows;
import me.leothepro555.skills.abilities.ArbalistExecute;
import me.leothepro555.skills.abilities.ArbalistFireCrossbow;
import me.leothepro555.skills.abilities.ArbalistPassive;
import me.leothepro555.skills.abilities.DevourerConsume;
import me.leothepro555.skills.abilities.DevourerEvolveCloak;
import me.leothepro555.skills.abilities.DevourerEvolveGliders;
import me.leothepro555.skills.abilities.DevourerEvolveSadism;
import me.leothepro555.skills.abilities.DevourerPassive;
import me.leothepro555.skills.abilities.EidolonDefile;
import me.leothepro555.skills.abilities.EidolonPassive;
import me.leothepro555.skills.abilities.EidolonPurify;
import me.leothepro555.skills.abilities.EidolonSpectre;
import me.leothepro555.skills.abilities.EidolonSpiritFire;
import me.leothepro555.skills.abilities.FireMageAbsorbEnergy;
import me.leothepro555.skills.abilities.FireMageBlackFire;
import me.leothepro555.skills.abilities.FireMageInferno;
import me.leothepro555.skills.abilities.FireMagePassive;
import me.leothepro555.skills.abilities.FireMagePhoenixEssence;
import me.leothepro555.skills.abilities.JuggernautAegisProtection;
import me.leothepro555.skills.abilities.JuggernautHeavyStrikes;
import me.leothepro555.skills.abilities.JuggernautPassive;
import me.leothepro555.skills.abilities.JuggernautStoneSkin;
import me.leothepro555.skills.abilities.JuggernautThrow;
import me.leothepro555.skills.abilities.MageEnergyFlux;
import me.leothepro555.skills.abilities.MageExplosionSpell;
import me.leothepro555.skills.abilities.MageHealSpell;
import me.leothepro555.skills.abilities.MagePassive;
import me.leothepro555.skills.abilities.MageReflect;
import me.leothepro555.skills.abilities.SwordsmanDodge;
import me.leothepro555.skills.abilities.SwordsmanParry;
import me.leothepro555.skills.abilities.SwordsmanPassive;
import me.leothepro555.skills.abilities.SwordsmanPierce;
import me.leothepro555.skills.abilities.SwordsmanThousandCuts;
import me.leothepro555.skills.abilities.VampireBleed;
import me.leothepro555.skills.abilities.VampireBloodLust;
import me.leothepro555.skills.abilities.VampireBloodWell;
import me.leothepro555.skills.abilities.VampireEternalDarkness;
import me.leothepro555.skills.abilities.VampirePassive;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.stats.StatType;
import me.leothepro555.skills.utils.XMaterial;
import me.leothepro555.skilltype.EnergyType;
import me.leothepro555.skilltype.ScalingType;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class SkillTypeManager {
    private Skills plugin;
    private Map<String, SkillType> skilltypes = new HashMap<String, SkillType>();
    private AbilityManager abilityManager;

    public SkillTypeManager(Skills plugin) {
        this.plugin = plugin;
        this.abilityManager = new AbilityManager(plugin);
        this.initSkillTypes();
    }

    public AbilityManager getAbilityManager() {
        return this.abilityManager;
    }

    public void initSkillTypes() {
        SkillType none = new SkillType("none", LanguageSupport.Languages.None, new Ability[0], EnergyType.ENERGY, new ArrayList<StatType>(), LanguageSupport.Languages.None, LanguageSupport.Languages.None, LanguageSupport.Languages.None, Material.STONE);
        none.addScaling(ScalingType.HEALTH, SkillsConfig.ConfigOption.HEALTH_SCALING.getString(none));
        none.addScaling(ScalingType.ENERGY, SkillsConfig.ConfigOption.SCALING_SWORDSMAN_MAXENERGY.getString());
        none.addScaling(ScalingType.ENERGY_REGEN, SkillsConfig.ConfigOption.SCALING_SWORDSMAN_ENERGY_REGEN.getString());
        this.skilltypes.put(none.getConfigName(), none);
        this.registerSwordsman();
        this.registerDevourer();
        this.registerMage();
        this.registerFireMage();
        this.registerJuggernaut();
        this.registerArbalist();
        this.registerVampire();
        this.registerEidolon();
    }

    public Map<String, SkillType> getSkilltypes() {
        return this.skilltypes;
    }

    private void registerSwordsman() {
        SkillType swordsman = new SkillType("swordsman", LanguageSupport.Languages.Swordsman, new Ability[]{this.abilityManager.getAbility(SwordsmanPassive.class), this.abilityManager.getAbility(SwordsmanParry.class), this.abilityManager.getAbility(SwordsmanPierce.class), this.abilityManager.getAbility(SwordsmanDodge.class), this.abilityManager.getAbility(SwordsmanThousandCuts.class)}, EnergyType.ENERGY, new ArrayList(){
            {
                this.add(StatType.STR);
                this.add(StatType.DEX);
            }
        }, LanguageSupport.Languages.Swordsman_Strong, LanguageSupport.Languages.Swordsman_Weak, LanguageSupport.Languages.Swordsman_Description, Material.IRON_SWORD);
        swordsman.addScaling(ScalingType.HEALTH, SkillsConfig.ConfigOption.HEALTH_SCALING.getString(swordsman));
        swordsman.addScaling(ScalingType.ENERGY, SkillsConfig.ConfigOption.SCALING_SWORDSMAN_MAXENERGY.getString());
        swordsman.addScaling(ScalingType.ENERGY_REGEN, SkillsConfig.ConfigOption.SCALING_SWORDSMAN_ENERGY_REGEN.getString());
        this.skilltypes.put(swordsman.getConfigName(), swordsman);
    }

    private void registerDevourer() {
        SkillType devourer = new SkillType("devourer", LanguageSupport.Languages.Devourer, new Ability[]{this.abilityManager.getAbility(DevourerPassive.class), this.abilityManager.getAbility(DevourerEvolveGliders.class), this.abilityManager.getAbility(DevourerEvolveCloak.class), this.abilityManager.getAbility(DevourerEvolveSadism.class), this.abilityManager.getAbility(DevourerConsume.class)}, EnergyType.ENERGY, new ArrayList(){
            {
                this.add(StatType.STR);
                this.add(StatType.DEX);
            }
        }, LanguageSupport.Languages.Devourer_Strong, LanguageSupport.Languages.Devourer_Weak, LanguageSupport.Languages.Devourer_Description, Material.SPIDER_EYE);
        devourer.addScaling(ScalingType.HEALTH, SkillsConfig.ConfigOption.HEALTH_SCALING.getString(devourer));
        devourer.addScaling(ScalingType.ENERGY, SkillsConfig.ConfigOption.SCALING_DEVOURER_MAXENERGY.getString());
        devourer.addScaling(ScalingType.ENERGY_REGEN, SkillsConfig.ConfigOption.SCALING_DEVOURER_ENERGY_REGEN.getString());
        this.skilltypes.put(devourer.getConfigName(), devourer);
    }

    private void registerMage() {
        SkillType mage = new SkillType("mage", LanguageSupport.Languages.Mage, new Ability[]{this.abilityManager.getAbility(MagePassive.class), this.abilityManager.getAbility(MageReflect.class), this.abilityManager.getAbility(MageExplosionSpell.class), this.abilityManager.getAbility(MageHealSpell.class), this.abilityManager.getAbility(MageEnergyFlux.class)}, EnergyType.MANA, new ArrayList(){
            {
                this.add(StatType.INT);
                this.add(StatType.DEF);
            }
        }, LanguageSupport.Languages.Mage_Strong, LanguageSupport.Languages.Mage_Weak, LanguageSupport.Languages.Mage_Description, XMaterial.GOLDEN_HOE.parseMaterial());
        mage.addScaling(ScalingType.HEALTH, SkillsConfig.ConfigOption.HEALTH_SCALING.getString(mage));
        mage.addScaling(ScalingType.ENERGY, SkillsConfig.ConfigOption.SCALING_MAGE_MAXMANA.getString());
        mage.addScaling(ScalingType.ENERGY_REGEN, SkillsConfig.ConfigOption.SCALING_MAGE_MANA_REGEN.getString());
        this.skilltypes.put(mage.getConfigName(), mage);
    }

    private void registerFireMage() {
        SkillType firemage = new SkillType("firemage", LanguageSupport.Languages.FireMage, new Ability[]{this.abilityManager.getAbility(FireMagePassive.class), this.abilityManager.getAbility(FireMageAbsorbEnergy.class), this.abilityManager.getAbility(FireMagePhoenixEssence.class), this.abilityManager.getAbility(FireMageBlackFire.class), this.abilityManager.getAbility(FireMageInferno.class)}, EnergyType.HEALTH, new ArrayList(){
            {
                this.add(StatType.INT);
                this.add(StatType.STR);
            }
        }, LanguageSupport.Languages.FireMage_Strong, LanguageSupport.Languages.FireMage_Weak, LanguageSupport.Languages.FireMage_Description, Material.BLAZE_POWDER);
        firemage.addScaling(ScalingType.HEALTH, SkillsConfig.ConfigOption.HEALTH_SCALING.getString(firemage));
        firemage.addScaling(ScalingType.ENERGY, SkillsConfig.ConfigOption.HEALTH_SCALING.getString(firemage));
        this.skilltypes.put(firemage.getConfigName(), firemage);
    }

    private void registerJuggernaut() {
        SkillType juggernaut = new SkillType("juggernaut", LanguageSupport.Languages.Juggernaut, new Ability[]{this.abilityManager.getAbility(JuggernautPassive.class), this.abilityManager.getAbility(JuggernautHeavyStrikes.class), this.abilityManager.getAbility(JuggernautStoneSkin.class), this.abilityManager.getAbility(JuggernautAegisProtection.class), this.abilityManager.getAbility(JuggernautThrow.class)}, EnergyType.ENERGY, new ArrayList(){
            {
                this.add(StatType.STR);
                this.add(StatType.DEF);
            }
        }, LanguageSupport.Languages.Juggernaut_Strong, LanguageSupport.Languages.Juggernaut_Weak, LanguageSupport.Languages.Juggernaut_Description, Material.IRON_CHESTPLATE);
        juggernaut.addScaling(ScalingType.HEALTH, SkillsConfig.ConfigOption.HEALTH_SCALING.getString(juggernaut));
        juggernaut.addScaling(ScalingType.ENERGY, SkillsConfig.ConfigOption.SCALING_JUGGERNAUT_MAXENERGY.getString());
        juggernaut.addScaling(ScalingType.ENERGY_REGEN, SkillsConfig.ConfigOption.SCALING_JUGGERNAUT_ENERGY_REGEN.getString());
        this.skilltypes.put(juggernaut.getConfigName(), juggernaut);
    }

    private void registerArbalist() {
        SkillType arbalist = new SkillType("arbalist", LanguageSupport.Languages.Arbalist, new Ability[]{this.abilityManager.getAbility(ArbalistPassive.class), this.abilityManager.getAbility(ArbalistExecute.class), this.abilityManager.getAbility(ArbalistDualArrows.class), this.abilityManager.getAbility(ArbalistBarbedArrow.class), this.abilityManager.getAbility(ArbalistFireCrossbow.class)}, EnergyType.ARROWS, new ArrayList(){
            {
                this.add(StatType.STR);
                this.add(StatType.DEX);
            }
        }, LanguageSupport.Languages.Arbalist_Strong, LanguageSupport.Languages.Arbalist_Weak, LanguageSupport.Languages.Arbalist_Description, Material.BOW);
        arbalist.addScaling(ScalingType.HEALTH, SkillsConfig.ConfigOption.HEALTH_SCALING.getString(arbalist));
        arbalist.addScaling(ScalingType.ENERGY, SkillsConfig.ConfigOption.SCALING_ARBALIST_MAXENERGY.getString());
        arbalist.addScaling(ScalingType.ENERGY_REGEN, SkillsConfig.ConfigOption.SCALING_ARBALIST_ENERGY_REGEN.getString());
        this.skilltypes.put(arbalist.getConfigName(), arbalist);
    }

    private void registerVampire() {
        SkillType vampire = new SkillType("vampire", LanguageSupport.Languages.Vampire, new Ability[]{this.abilityManager.getAbility(VampirePassive.class), this.abilityManager.getAbility(VampireBloodLust.class), this.abilityManager.getAbility(VampireBloodWell.class), this.abilityManager.getAbility(VampireBleed.class), this.abilityManager.getAbility(VampireEternalDarkness.class)}, EnergyType.BLOOD, new ArrayList(){
            {
                this.add(StatType.STR);
                this.add(StatType.INT);
            }
        }, LanguageSupport.Languages.Vampire_Strong, LanguageSupport.Languages.Vampire_Weak, LanguageSupport.Languages.Vampire_Description, XMaterial.REDSTONE.parseMaterial());
        vampire.addScaling(ScalingType.HEALTH, SkillsConfig.ConfigOption.HEALTH_SCALING.getString(vampire));
        vampire.addScaling(ScalingType.ENERGY, SkillsConfig.ConfigOption.SCALING_VAMPIRE_MAXBLOOD.getString());
        vampire.addScaling(ScalingType.ENERGY_REGEN, SkillsConfig.ConfigOption.SCALING_VAMPIRE_BLOOD_DROP_RATE.getString());
        this.skilltypes.put(vampire.getConfigName(), vampire);
    }

    private void registerEidolon() {
        SkillType eidolon = new SkillType("eidolon", LanguageSupport.Languages.Eidolon, new Ability[]{this.abilityManager.getAbility(EidolonPassive.class), this.abilityManager.getAbility(EidolonPurify.class), this.abilityManager.getAbility(EidolonSpiritFire.class), this.abilityManager.getAbility(EidolonSpectre.class), this.abilityManager.getAbility(EidolonDefile.class)}, EnergyType.IMBALANCE, new ArrayList(){
            {
                this.add(StatType.STR);
                this.add(StatType.INT);
            }
        }, LanguageSupport.Languages.Eidolon_Strong, LanguageSupport.Languages.Eidolon_Weak, LanguageSupport.Languages.Eidolon_Description, XMaterial.BLACK_WOOL.parseMaterial());
        eidolon.addScaling(ScalingType.HEALTH, SkillsConfig.ConfigOption.HEALTH_SCALING.getString(eidolon));
        eidolon.addScaling(ScalingType.ENERGY, SkillsConfig.ConfigOption.SCALING_EIDOLON_MAXIMBALANCE.getString());
        eidolon.addScaling(ScalingType.ENERGY_REGEN, SkillsConfig.ConfigOption.SCALING_EIDOLON_IMBALANCE_RATE.getString());
        this.skilltypes.put(eidolon.getConfigName(), eidolon);
    }

    public static int defineHoeChance(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (!item.getType().toString().endsWith("HOE")) {
            return 0;
        }
        if (item.getType() == XMaterial.WOODEN_HOE.parseMaterial()) {
            return 20;
        }
        if (item.getType() == Material.STONE_HOE) {
            return 30;
        }
        if (item.getType() == Material.IRON_HOE) {
            return 40;
        }
        if (item.getType() == XMaterial.GOLDEN_HOE.parseMaterial()) {
            return 50;
        }
        if (item.getType() == Material.DIAMOND_HOE) {
            return 60;
        }
        return 0;
    }

    public static int defineHoeDamage(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (!item.getType().toString().endsWith("HOE")) {
            return 0;
        }
        if (item.getType() == XMaterial.WOODEN_HOE.parseMaterial()) {
            return 4;
        }
        if (item.getType() == Material.STONE_HOE) {
            return 6;
        }
        if (item.getType() == Material.IRON_HOE) {
            return 8;
        }
        if (item.getType() == XMaterial.GOLDEN_HOE.parseMaterial()) {
            return 9;
        }
        if (item.getType() == Material.DIAMOND_HOE) {
            return 10;
        }
        return 0;
    }
}

