/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skilltype;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.abilities.VampireBloodWell;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.stats.StatType;
import me.leothepro555.skills.utils.MathUtil;
import me.leothepro555.skilltype.EnergyType;
import me.leothepro555.skilltype.ScalingType;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class SkillType {
    private String configName;
    private LanguageSupport.Languages languageName;
    private Ability[] abilities;
    private EnergyType energyType;
    private Map<ScalingType, String> scaling = new HashMap<ScalingType, String>();
    private Collection<StatType> statTypes;
    private LanguageSupport.Languages strengths;
    private LanguageSupport.Languages weaknesses;
    private LanguageSupport.Languages description;
    private Material mat;

    public SkillType(String configName, LanguageSupport.Languages languageName, Ability[] abilities, EnergyType energyType, Collection<StatType> statTypes, LanguageSupport.Languages strengths, LanguageSupport.Languages weaknesses, LanguageSupport.Languages description, Material mat) {
        this.configName = configName;
        this.languageName = languageName;
        this.abilities = abilities;
        this.energyType = energyType;
        this.statTypes = statTypes;
        this.strengths = strengths;
        this.weaknesses = weaknesses;
        this.description = description;
        this.mat = mat;
    }

    public void addScaling(ScalingType type, String scale) {
        this.scaling.put(type, scale);
    }

    public String getConfigName() {
        return this.configName;
    }

    public Ability[] getAbilities() {
        return this.abilities;
    }

    public EnergyType getEnergyType() {
        return this.energyType;
    }

    public Collection<StatType> getStatTypes() {
        return this.statTypes;
    }

    public LanguageSupport.Languages getLanguageName() {
        return this.languageName;
    }

    public double getScaling(Player p, ScalingType type) {
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (info == null) {
            Skills.logDebug("INFO NULL");
        }
        if (this.scaling.get((Object)type) == null) {
            Skills.logDebug("TYPE NULL");
        }
        String eqn = this.scaling.get((Object)type).toLowerCase().replaceAll("%", "").replaceAll("level", String.valueOf(info.getLevel())).replaceAll("lvl", String.valueOf(info.getLevel())).replaceAll("str", String.valueOf(info.getStatstr())).replaceAll("int", String.valueOf(info.getStatint())).replaceAll("dex", String.valueOf(info.getStatdex())).replaceAll("def", String.valueOf(info.getStatdef())).replaceAll("bloodwell", String.valueOf(info.getSkillImprovementLevel(VampireBloodWell.class)));
        return MathUtil.evaluateEquation(eqn);
    }

    public LanguageSupport.Languages getStrengths() {
        return this.strengths;
    }

    public LanguageSupport.Languages getWeaknesses() {
        return this.weaknesses;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SkillType)) {
            return false;
        }
        SkillType type = (SkillType)obj;
        return type.getConfigName().equals(this.configName);
    }

    public Material getMat() {
        return this.mat;
    }

    public LanguageSupport.Languages getDescription() {
        return this.description;
    }
}

