/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skilltype;

import java.util.ArrayList;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.interactivegui.InteractiveGUI;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.utils.Cooldown;
import me.leothepro555.skills.utils.GUIDesignType;
import me.leothepro555.skills.utils.InventoryUtils;
import me.leothepro555.skills.utils.LoreUtil;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SkillSelectorMenuManager {
    private Skills plugin;

    public SkillSelectorMenuManager(Skills plugin) {
        this.plugin = plugin;
    }

    public void performCommands(Player p, boolean isSelect) {
        block6: {
            PlayerInfo info;
            block5: {
                info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
                if (!isSelect) break block5;
                if (!SkillsConfig.ConfigOption.PERFORM_COMMAND_SELECT.getBoolean()) break block6;
                for (String command : SkillsConfig.ConfigOption.COMMANDS_TO_PERFORM_SELECT_PLAYER.getStringList(info.getSkill())) {
                    Bukkit.dispatchCommand((CommandSender)p, (String)command.replaceAll("%player%", p.getName()).replaceAll("%level%", "" + info.getLevel()));
                }
                for (String command : SkillsConfig.ConfigOption.COMMANDS_TO_PERFORM_SELECT_CONSOLE.getStringList(info.getSkill())) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replaceAll("%player%", p.getName()).replaceAll("%level%", "" + info.getLevel()));
                }
                break block6;
            }
            if (SkillsConfig.ConfigOption.PERFORM_COMMAND_CHANGE.getBoolean()) {
                for (String command : SkillsConfig.ConfigOption.COMMANDS_TO_PERFORM_CHANGE_PLAYER.getStringList(info.getSkill())) {
                    Bukkit.dispatchCommand((CommandSender)p, (String)command.replaceAll("%player%", p.getName()).replaceAll("%level%", "" + info.getLevel()));
                }
                for (String command : SkillsConfig.ConfigOption.COMMANDS_TO_PERFORM_CHANGE_CONSOLE.getStringList(info.getSkill())) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replaceAll("%player%", p.getName()).replaceAll("%level%", "" + info.getLevel()));
                }
            }
        }
    }

    public void openMenu(final Player p) {
        InteractiveGUI gui = new InteractiveGUI(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Selection_Title), 54);
        final PlayerInfo info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        ArrayList<Integer> slots = InventoryUtils.getCentralSlots(gui.getInventory());
        for (final SkillType type : this.plugin.getSkillTypeManager().getSkilltypes().values()) {
            if (type.getConfigName().equals("none")) continue;
            int slot = slots.remove(0);
            gui.getInventory().setItem(slot, this.getSkillSelectItem(type));
            gui.setAction(slot, new Runnable(){

                @Override
                public void run() {
                    if (p.hasPermission("skills.select.*") || p.hasPermission("skills.select." + type.getConfigName())) {
                        SkillSelectorMenuManager.this.performCommands(p, info.getSkill().getConfigName().equals("none"));
                        info.setSkill(type);
                        p.closeInventory();
                        p.sendMessage(ChatColor.GREEN + Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Skill_Selected).replace("%skill%", Skills.getLang().parseFirstString(type.getLanguageName())));
                        Cooldown cd = new Cooldown(p.getUniqueId(), "skillchange", SkillsConfig.ConfigOption.SKILL_CHANGE_COOLDOWN.getInt());
                        cd.start();
                    } else if (!p.hasPermission("skills.change")) {
                        p.sendMessage(ChatColor.RED + Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_No_Perm_Error));
                        return;
                    }
                }
            });
        }
        InventoryUtils.decorateInventory(gui.getInventory(), GUIDesignType.SELECTION);
        gui.openInventory(p);
    }

    private ItemStack getSkillSelectItem(SkillType type) {
        ItemStack item = new ItemStack(type.getMat());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Skills.getLang().parseFirstString(type.getLanguageName()));
        ArrayList<String> lore = new ArrayList<String>();
        lore = LoreUtil.addLore(Skills.getLang().parseFirstString(type.getDescription()), lore, ChatColor.BLUE);
        lore = LoreUtil.addLore(Skills.getLang().parseFirstString(type.getStrengths()), lore, ChatColor.GREEN);
        lore = LoreUtil.addLore(Skills.getLang().parseFirstString(type.getWeaknesses()), lore, ChatColor.RED);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    static /* synthetic */ Skills access$0(SkillSelectorMenuManager skillSelectorMenuManager) {
        return skillSelectorMenuManager.plugin;
    }
}

