/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skilltype;

import java.util.ArrayList;
import java.util.Iterator;
import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.interactivegui.InteractiveGUI;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.utils.GUIDesignType;
import me.leothepro555.skills.utils.InventoryUtils;
import me.leothepro555.skills.utils.XMaterial;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class AbilityGUIManager {
    public static void openMenu(final Player p) {
        InteractiveGUI menu = new InteractiveGUI(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Improve_Title), 54);
        final PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (info.getSkill().getConfigName().equals("none")) {
            return;
        }
        Ability[] abs = info.getSkill().getAbilities();
        int i = 0;
        while (i < abs.length) {
            final Ability ab = abs[i];
            int slot = i * 9 + 2;
            if (i == 0) {
                slot = 49;
            }
            menu.getInventory().setItem(slot, ab.getDescriptiveItem(info));
            menu.setAction(slot, new Runnable(){

                @Override
                public void run() {
                    if (info.getSkillImprovementLevel(ab) >= 3 || ab.isPassive) {
                        info.toggleDisabled(ab);
                        AbilityGUIManager.openMenu(p);
                        return;
                    }
                    int cost = ab.getSoulCost(info.getSkillImprovementLevel(ab));
                    if (info.getSouls() >= cost) {
                        info.upgradeSkillImprovement(ab);
                        p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Improvement_Upgraded));
                        info.setSouls(info.getSouls() - cost);
                    } else {
                        p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Souls));
                    }
                    AbilityGUIManager.openMenu(p);
                }
            });
            if (i != 0) {
                ArrayList<Integer> levelBars = new ArrayList<Integer>();
                levelBars.add(slot + 1);
                levelBars.add(slot + 2);
                levelBars.add(slot + 3);
                int level = info.getSkillImprovementLevel(ab);
                Iterator iterator = levelBars.iterator();
                while (iterator.hasNext()) {
                    int levelBar = (Integer)iterator.next();
                    if (level == 3) {
                        menu.getInventory().setItem(levelBar, InventoryUtils.getDecal(XMaterial.LIME_STAINED_GLASS_PANE));
                        continue;
                    }
                    if (level > 0) {
                        --level;
                        menu.getInventory().setItem(levelBar, InventoryUtils.getDecal(XMaterial.YELLOW_STAINED_GLASS_PANE));
                        continue;
                    }
                    menu.getInventory().setItem(levelBar, InventoryUtils.getDecal(XMaterial.BLACK_STAINED_GLASS_PANE));
                }
                if (level == 3) {
                    menu.getInventory().setItem(slot + 4, InventoryUtils.getDecal(XMaterial.BLUE_STAINED_GLASS_PANE));
                } else {
                    menu.getInventory().setItem(slot + 4, InventoryUtils.getDecal(XMaterial.GRAY_STAINED_GLASS_PANE));
                }
            }
            ++i;
        }
        InventoryUtils.decorateInventory(menu.getInventory(), GUIDesignType.IMPROVE);
        menu.openInventory(p);
    }
}

