/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.utils;

import java.util.ArrayList;
import java.util.Arrays;
import me.leothepro555.skills.utils.GUIDesignType;
import me.leothepro555.skills.utils.XMaterial;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryUtils {
    public static ItemStack getDecal(XMaterial mat) {
        ItemStack decal = mat.parseItem();
        ItemMeta meta = decal.getItemMeta();
        meta.setDisplayName("" + ChatColor.BLACK);
        decal.setItemMeta(meta);
        return decal;
    }

    public static void fillEmpty(Inventory inv, XMaterial fill) {
        int slot = 0;
        while (slot < inv.getSize()) {
            if (inv.getItem(slot) == null || inv.getItem(slot).getType() == Material.AIR) {
                inv.setItem(slot, InventoryUtils.getDecal(fill));
            }
            ++slot;
        }
    }

    public static void decorateInventory(Inventory inv, GUIDesignType type) {
        if (type == GUIDesignType.SELECTION) {
            for (int slot : InventoryUtils.getCornerSlots(inv)) {
                if (inv.getItem(slot) != null && inv.getItem(slot).getType() != Material.AIR) continue;
                if (slot % 2 == 0) {
                    inv.setItem(slot, InventoryUtils.getDecal(XMaterial.LIGHT_BLUE_STAINED_GLASS_PANE));
                    continue;
                }
                inv.setItem(slot, InventoryUtils.getDecal(XMaterial.BLUE_STAINED_GLASS_PANE));
            }
            InventoryUtils.fillEmpty(inv, XMaterial.GRAY_STAINED_GLASS_PANE);
        } else if (type == GUIDesignType.STAT) {
            for (int slot : InventoryUtils.getCornerSlots(inv)) {
                if (inv.getItem(slot) != null && inv.getItem(slot).getType() != Material.AIR) continue;
                if (slot % 2 == 0) {
                    inv.setItem(slot, InventoryUtils.getDecal(XMaterial.MAGENTA_STAINED_GLASS_PANE));
                    continue;
                }
                inv.setItem(slot, InventoryUtils.getDecal(XMaterial.PURPLE_STAINED_GLASS_PANE));
            }
            InventoryUtils.fillEmpty(inv, XMaterial.GRAY_STAINED_GLASS_PANE);
        } else if (type == GUIDesignType.IMPROVE) {
            for (int slot : InventoryUtils.getBorderSlots(inv)) {
                if (inv.getItem(slot) != null && inv.getItem(slot).getType() != Material.AIR) continue;
                inv.setItem(slot, InventoryUtils.getDecal(XMaterial.RED_STAINED_GLASS_PANE));
            }
        } else if (type == GUIDesignType.MASTERIES) {
            for (int slot : InventoryUtils.getCornerSlots(inv)) {
                if (inv.getItem(slot) != null && inv.getItem(slot).getType() != Material.AIR) continue;
                if (slot % 2 == 0) {
                    inv.setItem(slot, InventoryUtils.getDecal(XMaterial.ORANGE_STAINED_GLASS_PANE));
                    continue;
                }
                inv.setItem(slot, InventoryUtils.getDecal(XMaterial.YELLOW_STAINED_GLASS_PANE));
            }
            InventoryUtils.fillEmpty(inv, XMaterial.GRAY_STAINED_GLASS_PANE);
        }
    }

    public static ArrayList<Integer> getBorderSlots(Inventory inv) {
        Integer[] slots = inv.getSize() == 9 ? new Integer[]{} : (inv.getSize() == 18 ? new Integer[]{} : (inv.getSize() == 27 ? new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26} : (inv.getSize() == 36 ? new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35} : (inv.getSize() == 45 ? new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44} : (inv.getSize() == 54 ? new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53} : new Integer[]{})))));
        ArrayList<Integer> array = new ArrayList<Integer>(Arrays.asList(slots));
        return array;
    }

    public static ArrayList<Integer> getCornerSlots(Inventory inv) {
        Integer[] slots = inv.getSize() == 9 ? new Integer[]{0, 8} : (inv.getSize() == 18 ? new Integer[]{0, 8, 9, 17} : (inv.getSize() == 27 ? new Integer[]{0, 1, 7, 8, 9, 17, 18, 19, 25, 26} : (inv.getSize() == 36 ? new Integer[]{0, 1, 7, 8, 9, 17, 18, 26, 27, 28, 34, 35} : (inv.getSize() == 45 ? new Integer[]{0, 1, 7, 8, 9, 17, 27, 35, 36, 37, 43, 44} : (inv.getSize() == 54 ? new Integer[]{0, 1, 2, 6, 7, 8, 9, 10, 16, 17, 18, 26, 27, 35, 36, 37, 43, 44, 45, 46, 47, 51, 52, 53} : new Integer[]{0, 8})))));
        ArrayList<Integer> array = new ArrayList<Integer>(Arrays.asList(slots));
        return array;
    }

    public static ArrayList<Integer> getCentralSlots(Inventory inv) {
        Integer[] slots = inv.getSize() == 9 ? new Integer[]{2, 3, 4, 5, 6} : (inv.getSize() == 18 ? new Integer[]{2, 3, 4, 5, 6, 11, 12, 13, 14, 15} : (inv.getSize() == 27 ? new Integer[]{11, 12, 13, 14, 15} : (inv.getSize() == 36 ? new Integer[]{11, 12, 13, 14, 15, 20, 21, 22, 23, 24} : (inv.getSize() == 45 ? new Integer[]{11, 12, 13, 14, 15, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33} : (inv.getSize() == 54 ? new Integer[]{22, 21, 23, 20, 24, 31, 30, 32, 29, 33, 40, 39, 41, 38, 42, 13, 11, 14, 12, 15} : new Integer[]{2, 3, 4, 5, 6})))));
        ArrayList<Integer> array = new ArrayList<Integer>(Arrays.asList(slots));
        return array;
    }
}

