/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.stats;

import java.util.ArrayList;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.interactivegui.InteractiveGUI;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.stats.StatType;
import me.leothepro555.skills.utils.GUIDesignType;
import me.leothepro555.skills.utils.InventoryUtils;
import me.leothepro555.skills.utils.LoreUtil;
import me.leothepro555.skills.utils.XMaterial;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class StatMenuManager
implements Listener {
    private Skills plugin;

    public StatMenuManager(Skills plugin) {
        this.plugin = plugin;
    }

    public void distributeStats(Player p) {
        PlayerInfo info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        int stats = info.getStat(StatType.POINTS);
        int statstouse = 0;
        if (stats % 2 == 0) {
            statstouse = stats;
        } else {
            statstouse = stats - 1;
            if (stats == 1) {
                p.sendMessage(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Misc_Two_Statpoints_Needed));
                return;
            }
        }
        ArrayList<StatType> toAdd = new ArrayList<StatType>();
        for (StatType type : info.getSkill().getStatTypes()) {
            toAdd.add(type);
        }
        if (toAdd.isEmpty()) {
            return;
        }
        int spent = 0;
        int cost = 0;
        for (StatType stat : toAdd) {
            if (info.getStat(stat) + statstouse / 2 <= SkillsConfig.ConfigOption.STAT_MAX.getInt()) {
                info.setStat(stat, info.getStat(stat) + statstouse / 2);
                spent = statstouse / 2;
                cost += spent;
            } else {
                spent = SkillsConfig.ConfigOption.STAT_MAX.getInt() - info.getStat(stat);
                cost += spent;
                info.setStat(stat, SkillsConfig.ConfigOption.STAT_MAX.getInt());
            }
            p.sendMessage(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Misc_Statpoints_Distribution).replaceAll("%amount%", "" + spent).replaceAll("%stat%", stat.getStringName().toUpperCase()));
        }
        info.setStat(StatType.POINTS, info.getStat(StatType.POINTS) - cost);
        p.sendMessage(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Misc_Statpoints_Spent).replaceAll("%amount%", "" + cost));
    }

    public void addAllPoints(Player p, StatType type) {
        PlayerInfo info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (info.getStat(StatType.POINTS) > 0) {
            info.setStat(type, info.getStat(StatType.POINTS) + info.getStat(type));
            info.setStat(StatType.POINTS, 0);
            if (info.getStat(type) > SkillsConfig.ConfigOption.STAT_MAX.getInt()) {
                int diff = info.getStat(type) - SkillsConfig.ConfigOption.STAT_MAX.getInt();
                info.setStat(StatType.POINTS, diff);
                info.setStat(type, SkillsConfig.ConfigOption.STAT_MAX.getInt());
            }
        } else {
            p.sendMessage(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Misc_Not_enough_Statpoints));
        }
    }

    public void addToStat(Player p, StatType type) {
        PlayerInfo info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (info.getStat(StatType.POINTS) > 0) {
            if (info.getStat(type) == SkillsConfig.ConfigOption.STAT_MAX.getInt()) {
                return;
            }
            info.setStat(type, info.getStat(type) + 1);
            info.setStat(StatType.POINTS, info.getStat(StatType.POINTS) - 1);
        } else {
            p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_enough_Statpoints));
        }
    }

    public void openMenu(final Player p) {
        InteractiveGUI gui = new InteractiveGUI(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Title), 54);
        final PlayerInfo info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        ItemStack str = new ItemStack(Material.IRON_SWORD);
        ItemMeta strmeta = str.getItemMeta();
        strmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_STR));
        ArrayList<String> strlore = new ArrayList<String>();
        strlore.add(String.valueOf(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Level)) + info.getStat(StatType.STR));
        strmeta.setLore(strlore);
        str.setItemMeta(strmeta);
        ItemStack inte = new ItemStack(Material.BOOK);
        ItemMeta intmeta = inte.getItemMeta();
        intmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_INT));
        ArrayList<String> intlore = new ArrayList<String>();
        intlore.add(String.valueOf(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Level)) + info.getStat(StatType.INT));
        intmeta.setLore(intlore);
        inte.setItemMeta(intmeta);
        ItemStack dex = new ItemStack(Material.QUARTZ);
        ItemMeta dexmeta = dex.getItemMeta();
        dexmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_DEX));
        ArrayList<String> dexlore = new ArrayList<String>();
        dexlore.add(String.valueOf(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Level)) + info.getStat(StatType.DEX));
        dexmeta.setLore(dexlore);
        dex.setItemMeta(dexmeta);
        ItemStack def = new ItemStack(Material.IRON_CHESTPLATE);
        ItemMeta defmeta = def.getItemMeta();
        defmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_DEF));
        ArrayList<String> deflore = new ArrayList<String>();
        deflore.add(String.valueOf(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Level)) + info.getStat(StatType.DEF));
        defmeta.setLore(deflore);
        def.setItemMeta(defmeta);
        ItemStack strten = new ItemStack(Material.IRON_SWORD);
        ItemMeta strtenmeta = strten.getItemMeta();
        strtenmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_STR_ADDALL));
        ArrayList<String> strtenlore = new ArrayList<String>();
        strtenlore.add(String.valueOf(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Level)) + info.getStat(StatType.STR));
        strtenmeta.setLore(strtenlore);
        strten.setItemMeta(strtenmeta);
        ItemStack intten = new ItemStack(Material.BOOK);
        ItemMeta inttenmeta = intten.getItemMeta();
        inttenmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_INT_ADDALL));
        ArrayList<String> inttenlore = new ArrayList<String>();
        inttenlore.add(String.valueOf(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Level)) + info.getStat(StatType.INT));
        inttenmeta.setLore(inttenlore);
        intten.setItemMeta(inttenmeta);
        ItemStack dexten = new ItemStack(Material.QUARTZ);
        ItemMeta dextenmeta = dexten.getItemMeta();
        dextenmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_DEX_ADDALL));
        ArrayList<String> dextenlore = new ArrayList<String>();
        dextenlore.add(String.valueOf(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Level)) + info.getStat(StatType.DEX));
        dextenmeta.setLore(dextenlore);
        dexten.setItemMeta(dextenmeta);
        ItemStack deften = new ItemStack(Material.IRON_CHESTPLATE);
        ItemMeta deftenmeta = deften.getItemMeta();
        deftenmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_DEF_ADDALL));
        ArrayList<String> deftenlore = new ArrayList<String>();
        deftenlore.add(String.valueOf(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Level)) + info.getStat(StatType.DEF));
        deftenmeta.setLore(deftenlore);
        deften.setItemMeta(deftenmeta);
        ItemStack points = new ItemStack(Material.NETHER_STAR);
        ItemMeta pointsmeta = points.getItemMeta();
        pointsmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_StatPoints));
        ArrayList<String> pointslore = new ArrayList<String>();
        pointslore.add(String.valueOf(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Amount)) + info.getStat(StatType.POINTS));
        pointsmeta.setLore(pointslore);
        points.setItemMeta(pointsmeta);
        ItemStack autoadd = XMaterial.YELLOW_STAINED_GLASS_PANE.parseItem();
        ItemMeta autoaddmeta = autoadd.getItemMeta();
        autoaddmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_AutoAssign));
        ArrayList<String> autoaddlore = new ArrayList<String>();
        autoaddlore = LoreUtil.addLore(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_StatMenu_AutoAssign_Desc), autoaddlore, ChatColor.YELLOW);
        autoaddmeta.setLore(autoaddlore);
        autoadd.setItemMeta(autoaddmeta);
        ItemStack reset = XMaterial.RED_STAINED_GLASS_PANE.parseItem();
        ItemMeta resetmeta = reset.getItemMeta();
        resetmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_ResetStats));
        ArrayList<String> resetlore = new ArrayList<String>();
        if (SkillsConfig.ConfigOption.STATS_RESET_COST.getInt() > 0) {
            Skills.get();
            resetlore.add(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Improve_Cost)) + SkillsConfig.ConfigOption.STATS_RESET_COST.getInt());
        }
        resetmeta.setLore(resetlore);
        reset.setItemMeta(resetmeta);
        ItemStack help = new ItemStack(XMaterial.GLASS_PANE.parseMaterial());
        ItemMeta helpmeta = help.getItemMeta();
        helpmeta.setDisplayName(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Explanation));
        ArrayList helplore = new ArrayList();
        helpmeta.setLore(helplore);
        help.setItemMeta(helpmeta);
        gui.getInventory().setItem(13, points);
        gui.getInventory().setItem(20, str);
        gui.setAction(20, new Runnable(){

            @Override
            public void run() {
                StatMenuManager.this.addToStat(p, StatType.STR);
                StatMenuManager.this.openMenu(p);
            }
        });
        gui.getInventory().setItem(21, inte);
        gui.setAction(21, new Runnable(){

            @Override
            public void run() {
                StatMenuManager.this.addToStat(p, StatType.INT);
                StatMenuManager.this.openMenu(p);
            }
        });
        gui.getInventory().setItem(22, dex);
        gui.setAction(22, new Runnable(){

            @Override
            public void run() {
                StatMenuManager.this.addToStat(p, StatType.DEX);
                StatMenuManager.this.openMenu(p);
            }
        });
        gui.getInventory().setItem(23, def);
        gui.setAction(23, new Runnable(){

            @Override
            public void run() {
                StatMenuManager.this.addToStat(p, StatType.DEF);
                StatMenuManager.this.openMenu(p);
            }
        });
        if (SkillsConfig.ConfigOption.STATS_ALLOW_RESET.getBoolean()) {
            gui.getInventory().setItem(24, reset);
            gui.setAction(24, new Runnable(){

                @Override
                public void run() {
                    int cost = SkillsConfig.ConfigOption.STATS_RESET_COST.getInt();
                    if (cost > 0 && info.getSouls() - cost < 0) {
                        Skills.get();
                        p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Souls));
                        return;
                    }
                    info.setSouls(info.getSouls() - cost);
                    info.resetStats();
                    StatMenuManager.this.openMenu(p);
                }
            });
        }
        gui.getInventory().setItem(29, strten);
        gui.setAction(29, new Runnable(){

            @Override
            public void run() {
                StatMenuManager.this.addAllPoints(p, StatType.STR);
                StatMenuManager.this.openMenu(p);
            }
        });
        gui.getInventory().setItem(30, intten);
        gui.setAction(30, new Runnable(){

            @Override
            public void run() {
                StatMenuManager.this.addAllPoints(p, StatType.INT);
                StatMenuManager.this.openMenu(p);
            }
        });
        gui.getInventory().setItem(31, dexten);
        gui.setAction(31, new Runnable(){

            @Override
            public void run() {
                StatMenuManager.this.addAllPoints(p, StatType.DEX);
                StatMenuManager.this.openMenu(p);
            }
        });
        gui.getInventory().setItem(32, deften);
        gui.setAction(32, new Runnable(){

            @Override
            public void run() {
                StatMenuManager.this.addAllPoints(p, StatType.DEF);
                StatMenuManager.this.openMenu(p);
            }
        });
        gui.getInventory().setItem(33, autoadd);
        gui.setAction(33, new Runnable(){

            @Override
            public void run() {
                StatMenuManager.this.distributeStats(p);
                StatMenuManager.this.openMenu(p);
            }
        });
        gui.getInventory().setItem(40, help);
        gui.setAction(40, new Runnable(){

            @Override
            public void run() {
                p.closeInventory();
                p.sendMessage(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Guis_StatMenu_Explanation_Message));
            }
        });
        InventoryUtils.decorateInventory(gui.getInventory(), GUIDesignType.STAT);
        gui.openInventory(p);
    }

    static /* synthetic */ Skills access$0(StatMenuManager statMenuManager) {
        return statMenuManager.plugin;
    }
}

