/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.serialize;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import me.leothepro555.skills.serialize.FileSerializeException;
import me.leothepro555.skills.serialize.Utf8YamlConfiguration;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;

public abstract class FileSerialize {
    private File dbPath;
    protected Utf8YamlConfiguration db;

    public FileSerialize(File folder, String fileName) throws FileSerializeException {
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.dbPath = new File(folder, fileName);
        if (!this.dbPath.exists()) {
            try {
                Bukkit.getLogger().info("Creating file " + fileName);
                this.dbPath.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getLogger().warning("Failed to create file " + fileName);
                throw new FileSerializeException("Failed to create file " + fileName);
            }
        }
        this.db = new Utf8YamlConfiguration();
        try {
            this.db.load(new FileInputStream(this.dbPath));
        }
        catch (IOException | InvalidConfigurationException e) {
            Bukkit.getLogger().warning("Failed to load " + fileName);
            e.printStackTrace();
            throw new FileSerializeException("Failed to load " + fileName);
        }
        if (this.db == null) {
            Bukkit.getLogger().warning("Failed to load " + fileName);
            throw new FileSerializeException("Failed to load " + fileName);
        }
    }

    protected boolean deleteFile() {
        this.db = null;
        return this.dbPath.delete();
    }

    protected void clearAll() throws FileSerializeException {
        for (Map.Entry entry : this.db.getValues(false).entrySet()) {
            this.db.set((String)entry.getKey(), null);
        }
    }

    protected void saveAll() throws FileSerializeException {
        try {
            this.db.save(this.dbPath);
        }
        catch (IOException e) {
            Bukkit.getLogger().warning("saveAll() failed");
            throw new FileSerializeException("saveAll() failed");
        }
    }

    protected void save(String key, Object val) throws FileSerializeException {
        Validate.notNull((Object)key);
        this.db.set(key, val);
        try {
            this.db.save(this.dbPath);
        }
        catch (IOException e) {
            Bukkit.getLogger().warning("saveAll() failed");
            throw new FileSerializeException("saveAll() failed");
        }
    }

    protected Object load(String key) {
        return this.db.get(key);
    }

    protected Object load(String key, Object def) {
        return this.db.get(key, def);
    }

    public void reload() {
        try {
            this.db.load(this.dbPath);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

