/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.party;

import java.util.HashMap;
import java.util.UUID;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.party.Party;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PartyManager
implements Listener {
    private static HashMap<UUID, Party> playerparty = new HashMap();
    private static HashMap<UUID, UUID> playerinvites = new HashMap();
    public static HashMap<UUID, Party> parties = new HashMap();
    private Skills plugin;

    public PartyManager(Skills plugin) {
        this.plugin = plugin;
    }

    public static boolean hasParty(UUID uuid) {
        return playerparty.containsKey(uuid);
    }

    public static Party getParty(UUID uuid) {
        return playerparty.get(uuid);
    }

    public static void createParty(UUID uuid) {
        Party party = new Party(uuid);
        playerparty.put(uuid, party);
        parties.put(party.getUniqueId(), party);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (PartyManager.hasParty(uuid)) {
            Party party = PartyManager.getParty(uuid);
            if (!party.getLeader().equals(uuid)) {
                PartyManager.removePlayerFromParty(uuid);
            } else {
                PartyManager.removePlayerFromParty(uuid);
                party.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Leader_Left).replaceAll("%player%", Bukkit.getOfflinePlayer((UUID)party.getLeader()).getName()));
            }
        }
    }

    @EventHandler
    public void onFight(EntityDamageByEntityEvent event) {
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            UUID dmguuid = event.getDamager().getUniqueId();
            if (!PartyManager.hasParty(dmguuid)) {
                return;
            }
            if (!PartyManager.hasParty(event.getEntity().getUniqueId())) {
                return;
            }
            if (PartyManager.hasParty(dmguuid) && PartyManager.getParty(dmguuid).equals(PartyManager.getParty(event.getEntity().getUniqueId()))) {
                event.setCancelled(true);
                ((Player)event.getDamager()).sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Cannot_Harm_Others));
            }
        } else if (event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof Player) {
            UUID dmguuid = ((Player)((Projectile)event.getDamager()).getShooter()).getUniqueId();
            if (!PartyManager.hasParty(event.getEntity().getUniqueId())) {
                return;
            }
            if (PartyManager.hasParty(dmguuid) && PartyManager.getParty(dmguuid).equals(PartyManager.getParty(event.getEntity().getUniqueId()))) {
                event.setCancelled(true);
                Bukkit.getPlayer((UUID)dmguuid).sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Cannot_Harm_Others));
            }
        }
    }

    public static void invitePlayerToParty(Player p, Party party) {
        playerinvites.put(p.getUniqueId(), party.getUniqueId());
    }

    public static Party getInvitedParty(Player p) {
        return PartyManager.getPartyFromUuid(playerinvites.get(p.getUniqueId()));
    }

    public static boolean isInvited(Player p) {
        return playerinvites.get(p.getUniqueId()) != null;
    }

    public static Party getPartyFromUuid(UUID uuid) {
        for (UUID id : parties.keySet()) {
            if (!id.equals(uuid)) continue;
            return parties.get(id);
        }
        return null;
    }

    public static void addPlayerToParty(UUID p, Party party) {
        if (PartyManager.hasParty(p)) {
            PartyManager.removePlayerFromParty(p);
        }
        playerparty.put(p, party);
        party.members.put(p, 0);
        if (Bukkit.getPlayer((UUID)p) != null && playerinvites.get(p) != null) {
            playerinvites.remove(p);
        }
        party.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Join_Announcement).replaceAll("%player%", Bukkit.getPlayer((UUID)p).getName()));
    }

    public static void removePlayerFromParty(UUID uuid) {
        Party oldparty = PartyManager.getParty(uuid);
        OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)uuid);
        oldparty.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Leave_Announcement).replaceAll("%player%", p.getName()));
        oldparty.removePlayer(uuid);
        if (oldparty.isEmpty()) {
            oldparty.disband();
        }
        if (playerparty.containsKey(uuid)) {
            playerparty.remove(uuid);
        }
    }
}

