/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.party;

import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.party.PartyManager;
import me.leothepro555.skills.utils.MathEval;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Party {
    private UUID leader;
    public HashMap<UUID, Integer> members = new HashMap();
    private UUID uuid;
    private boolean areMembersTooFar = false;

    public Party(UUID leader) {
        this.leader = leader;
        this.members.put(leader, 0);
        this.uuid = UUID.randomUUID();
    }

    public UUID getLeader() {
        return this.leader;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public boolean areMembersInRange() {
        int range = SkillsConfig.ConfigOption.PARTY_PARTY_MEMBERS_MAX_RANGE.getInt();
        if (range <= -1) {
            return true;
        }
        if (this.members.size() <= 1) {
            return true;
        }
        for (UUID id : this.members.keySet()) {
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)id);
            if (!op.isOnline()) continue;
            Player p = (Player)op;
            for (UUID otherid : this.members.keySet()) {
                OfflinePlayer otherop;
                if (otherid.equals(id) || !(otherop = Bukkit.getOfflinePlayer((UUID)otherid)).isOnline()) continue;
                Player otherp = (Player)otherop;
                if (!otherp.getWorld().equals(p.getWorld())) {
                    this.areMembersTooFar = true;
                    return false;
                }
                if (!(otherp.getLocation().distanceSquared(p.getLocation()) > (double)(range * range))) continue;
                this.areMembersTooFar = true;
                return false;
            }
        }
        this.areMembersTooFar = false;
        return true;
    }

    public boolean equals(Party party) {
        return party.uuid.toString().equals(this.uuid.toString());
    }

    public int parseBonusXp(double exp) {
        if (exp == 0.0) {
            return 0;
        }
        if (!this.areMembersInRange()) {
            this.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Members_too_far));
            return (int)exp;
        }
        return (int)new MathEval().evaluate(SkillsConfig.ConfigOption.PARTY_EXP_PER_PLAYER.getString().replaceAll("partysize", "" + this.members.size()).replaceAll("exp", "" + exp).replaceAll("xp", "" + exp));
    }

    public int parseBonusSouls(int souls) {
        if (souls == 0) {
            return 0;
        }
        if (this.areMembersTooFar) {
            return souls;
        }
        return (int)new MathEval().evaluate(SkillsConfig.ConfigOption.PARTY_SOULS_PER_PLAYER.getString().replaceAll("partysize", "" + this.members.size()).replaceAll("souls", "" + souls).replaceAll("soul", "" + souls));
    }

    public void disband() {
        for (UUID id : this.members.keySet()) {
            PartyManager.removePlayerFromParty(id);
        }
        PartyManager.parties.remove(this.getUniqueId());
    }

    public boolean isEmpty() {
        return this.members.size() <= 0;
    }

    public void sendMessage(String message) {
        for (UUID id : this.members.keySet()) {
            Player player = Bukkit.getPlayer((UUID)id);
            if (player == null) {
                this.removePlayer(id);
                return;
            }
            player.sendMessage(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Party_Message_Prefix)) + message);
        }
    }

    public void removePlayer(UUID uuid) {
        if (this.members.containsKey(uuid)) {
            this.members.remove(uuid);
        }
        if (this.leader.equals(uuid) && !this.isEmpty()) {
            Iterator<UUID> iterator = this.members.keySet().iterator();
            while (iterator.hasNext()) {
                UUID newleader;
                this.leader = newleader = iterator.next();
            }
        }
    }
}

