/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.masteries;

import java.util.Random;
import me.leothepro555.skills.damage.LastHitManager;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.masteries.Mastery;
import me.leothepro555.skills.utils.VersionSupport;
import me.leothepro555.skills.utils.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MasteryListener
implements Listener {
    @EventHandler
    public void onDefend(EntityDamageEvent event) {
        if (SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName()) && event.getEntity() instanceof Player) {
            Player p = (Player)event.getEntity();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.getMasteryLevel(Mastery.ThickSkin) > 0 && this.randInt(0, 100) < info.getMasteryLevel(Mastery.ThickSkin) * 5) {
                event.setDamage(event.getDamage() - 1.0);
            }
        }
    }

    @EventHandler
    public void onEat(PlayerItemConsumeEvent event) {
        if (SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getPlayer().getWorld().getName())) {
            Player p = event.getPlayer();
            PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
            if (info.getMasteryLevel(Mastery.Regeneration) > 0) {
                EntityRegainHealthEvent evnt = new EntityRegainHealthEvent((Entity)p, (double)info.getMasteryLevel(Mastery.Regeneration), EntityRegainHealthEvent.RegainReason.EATING);
                Bukkit.getPluginManager().callEvent((Event)evnt);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onAttack(final EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            Arrow a;
            if (event.getDamager() instanceof Player) {
                int amtarmor;
                final Player p = (Player)event.getDamager();
                final PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
                if (info.getMasteryLevel(Mastery.BruteForce) > 0 && (amtarmor = this.amtarmor((LivingEntity)p)) > 0) {
                    int finalplus = 0;
                    int i = 1;
                    while (i <= amtarmor) {
                        if (this.randInt(0, 100) <= info.getMasteryLevel(Mastery.BruteForce) * 3) {
                            ++finalplus;
                        }
                        ++i;
                    }
                    event.setDamage(event.getDamage() + (double)finalplus);
                }
                if (info.getMasteryLevel(Mastery.Serration) > 0 && this.randInt(0, 100) < info.getMasteryLevel(Mastery.Serration) * 3) {
                    new BukkitRunnable(){

                        public void run() {
                            LastHitManager.damageLivingEntity((LivingEntity)event.getEntity(), p, info.getMasteryLevel(Mastery.Serration));
                        }
                    }.runTaskLater((Plugin)Skills.get(), 20L);
                }
                if (info.getMasteryLevel(Mastery.Adriot) > 0 && p.getItemInHand() != null && p.getItemInHand().getType().toString().endsWith("SWORD") && this.randInt(0, 100) <= info.getMasteryLevel(Mastery.Adriot) * 5 && p.getItemInHand().getDurability() > -1) {
                    p.getItemInHand().setDurability((short)(p.getItemInHand().getDurability() - 1));
                }
                if (this.isCritical((Player)event.getDamager())) {
                    if (info.getMasteryLevel(Mastery.CriticalStrikes) > 0) {
                        float damage = info.getMasteryLevel(Mastery.CriticalStrikes) / 2;
                        if (event.getEntity() instanceof Player) {
                            damage = info.getMasteryLevel(Mastery.CriticalStrikes) / 4;
                        }
                        event.setDamage(event.getDamage() + (double)damage);
                    }
                    if (info.getMasteryLevel(Mastery.Power) > 0 && this.randInt(0, 100) < info.getMasteryLevel(Mastery.Power) * 3) {
                        event.setDamage(event.getDamage() + 1.0);
                    }
                    if (info.getMasteryLevel(Mastery.Exploit) > 0 && this.randInt(0, 100) < info.getMasteryLevel(Mastery.Exploit) * 3) {
                        event.setDamage(event.getDamage() + (double)this.amtarmor((LivingEntity)event.getEntity()));
                    }
                }
            } else if (event.getDamager() instanceof Arrow && (a = (Arrow)event.getDamager()).getShooter() instanceof Player) {
                Player p = (Player)a.getShooter();
                PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
                if (info.getMasteryLevel(Mastery.Adriot) > 0 && p.getItemInHand() != null && p.getItemInHand().getType() == Material.BOW && this.randInt(0, 100) <= info.getMasteryLevel(Mastery.Adriot) * 5 && p.getItemInHand().getDurability() > -1) {
                    p.getItemInHand().setDurability((short)(p.getItemInHand().getDurability() - 1));
                }
                if (info.getMasteryLevel(Mastery.Precision) > 0 && this.randInt(0, 100) < info.getMasteryLevel(Mastery.Precision) * 3) {
                    event.setDamage(event.getDamage() * 1.5);
                }
                if (info.getMasteryLevel(Mastery.Exploit) > 0 && this.randInt(0, 100) < info.getMasteryLevel(Mastery.Exploit) * 3) {
                    event.setDamage(event.getDamage() + (double)this.amtarmor((LivingEntity)event.getEntity()));
                }
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (MasteryListener.isPlaced(event.getBlock())) {
            return;
        }
        if (SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getBlock().getWorld().getName())) {
            Player p = event.getPlayer();
            if (event.getBlock().getType().toString().contains("LOG")) {
                PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
                if (info.getMasteryLevel(Mastery.Logging) > 0 && this.randInt(0, 100) < info.getMasteryLevel(Mastery.Logging) * 3) {
                    event.setCancelled(true);
                    ItemStack item = new ItemStack(XMaterial.OAK_PLANKS.parseMaterial(), 5);
                    p.getWorld().dropItemNaturally(event.getBlock().getLocation(), item);
                    event.getBlock().setType(Material.AIR);
                }
                Skills.logDebug("Pacifist is at " + info.getMasteryLevel(Mastery.Pacifist));
                if (info.getMasteryLevel(Mastery.Pacifist) > 0) {
                    Skills.logDebug("Retardation");
                    info.setExp(info.getExp() + info.getMasteryLevel(Mastery.Logging) / 3 + info.getMasteryLevel(Mastery.Pacifist));
                }
            }
        }
    }

    @EventHandler
    public void onHarvest(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getBlock().getWorld().getName())) {
            return;
        }
        Player p = event.getPlayer();
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (VersionSupport.isCropFullyGrown(event.getBlock())) {
            if (info.getMasteryLevel(Mastery.Harvesting) > 0 && this.randInt(0, 100) < info.getMasteryLevel(Mastery.Harvesting) * 3) {
                for (ItemStack drop : event.getBlock().getDrops()) {
                    p.getWorld().dropItemNaturally(event.getBlock().getLocation(), drop);
                }
            }
            if (info.getMasteryLevel(Mastery.Pacifist) > 0) {
                info.setExp(info.getExp() + info.getMasteryLevel(Mastery.Harvesting) / 3 + info.getMasteryLevel(Mastery.Pacifist));
            }
        }
        if (event.getBlock().getType() == Material.COAL_ORE || event.getBlock().getType() == Material.IRON_ORE || event.getBlock().getType() == Material.GOLD_ORE || event.getBlock().getType() == Material.DIAMOND_ORE || event.getBlock().getType() == Material.LAPIS_ORE || event.getBlock().getType() == Material.REDSTONE_ORE || event.getBlock().getType() == Material.EMERALD_ORE) {
            if (MasteryListener.isPlaced(event.getBlock())) {
                return;
            }
            if (info.getMasteryLevel(Mastery.Mining) > 0 && this.randInt(0, 100) < info.getMasteryLevel(Mastery.Mining) * 3) {
                for (ItemStack drop : event.getBlock().getDrops()) {
                    p.getWorld().dropItemNaturally(event.getBlock().getLocation(), drop);
                }
            }
        }
    }

    public boolean isCritical(Player p) {
        return p.getVelocity().getY() + 0.0784000015258789 <= 0.0;
    }

    public int amtarmor(LivingEntity e) {
        if (e instanceof Skeleton) {
            return ((Skeleton)e).getEquipment().getArmorContents().length;
        }
        if (e instanceof Zombie) {
            return ((Zombie)e).getEquipment().getArmorContents().length;
        }
        if (e instanceof PigZombie) {
            return ((PigZombie)e).getEquipment().getArmorContents().length;
        }
        if (e instanceof Player) {
            return ((Player)e).getEquipment().getArmorContents().length;
        }
        return 0;
    }

    public int randInt(int min, int max) {
        Random rand = new Random();
        int randomNum = rand.nextInt(max - min + 1) + min;
        return randomNum;
    }

    @EventHandler
    public void blockPlaceListener(BlockPlaceEvent event) {
        Block b = event.getBlock();
        b.setMetadata("PLACED", (MetadataValue)new FixedMetadataValue((Plugin)Skills.get(), (Object)"something"));
    }

    public static boolean isPlaced(Block b) {
        return b.hasMetadata("PLACED");
    }
}

