/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.masteries;

import java.util.ArrayList;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.interactivegui.InteractiveGUI;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.masteries.Mastery;
import me.leothepro555.skills.masteries.MasteryType;
import me.leothepro555.skills.utils.GUIDesignType;
import me.leothepro555.skills.utils.InventoryUtils;
import me.leothepro555.skills.utils.LoreUtil;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MasteryGUIManager {
    public static void upgradeMastery(Player p, Mastery type) {
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (info.getMasteryLevel(type) >= SkillsConfig.ConfigOption.MASTERY_MAX.getInt()) {
            p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Skill_Maximum_Level));
            return;
        }
        int cost = type.getCost(info);
        if (info.getSouls() >= cost) {
            info.setSouls(info.getSouls() - cost);
            info.upgradeMastery(type, 1);
            Skills.logDebug("Upgraded mastery of type " + type.toString() + " to level " + info.getMasteryLevel(type));
            p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Mastery_Upgraded));
            MasteryGUIManager.openMenu(p);
        } else {
            p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Souls));
        }
    }

    public static void openMenu(final Player p) {
        InteractiveGUI menu = new InteractiveGUI(Skills.getLang().parseFirstString(LanguageSupport.Languages.Mastery_Title), 54);
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        ArrayList<Integer> slots = InventoryUtils.getCentralSlots(menu.getInventory());
        MasteryType[] masteryTypeArray = MasteryType.values();
        int n = masteryTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MasteryType type = masteryTypeArray[n2];
            Mastery[] masteryArray = Mastery.values();
            int n3 = masteryArray.length;
            int n4 = 0;
            while (n4 < n3) {
                final Mastery mast = masteryArray[n4];
                if (mast.getType() == type) {
                    ItemStack i2 = new ItemStack(mast.getMat());
                    ItemMeta i2m = i2.getItemMeta();
                    i2m.setDisplayName(Skills.getLang().parseFirstString(mast.getTitle()));
                    ArrayList<String> i2l = new ArrayList<String>();
                    i2l.add("");
                    i2l.add(Skills.getLang().parseFirstString(type.getTitle()));
                    i2l = LoreUtil.addLore(Skills.getLang().parseFirstString(mast.getDesc()), i2l, ChatColor.AQUA);
                    i2l = LoreUtil.addLore(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Masteries_Cost)) + mast.getCost(info), i2l, ChatColor.AQUA);
                    i2l = LoreUtil.addLore(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Masteries_Level)) + info.getMasteryLevel(mast), i2l, ChatColor.AQUA);
                    i2m.setLore(i2l);
                    i2.setItemMeta(i2m);
                    int slot = slots.remove(0);
                    menu.setAction(slot, new Runnable(){

                        @Override
                        public void run() {
                            MasteryGUIManager.upgradeMastery(p, mast);
                        }
                    });
                    menu.getInventory().setItem(slot, i2);
                }
                ++n4;
            }
            ++n2;
        }
        InventoryUtils.decorateInventory(menu.getInventory(), GUIDesignType.MASTERIES);
        menu.openInventory(p);
    }
}

