/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.masteries;

import java.util.ArrayList;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.masteries.MasteryType;
import me.leothepro555.skills.utils.LoreUtil;
import me.leothepro555.skills.utils.XMaterial;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public enum Mastery {
    Logging(0, LanguageSupport.Languages.Mastery_Efficiency_Logging_Title, LanguageSupport.Languages.Mastery_Efficiency_Logging_Desc, XMaterial.WOODEN_AXE.parseMaterial(), MasteryType.EFFICIENCY),
    Harvesting(1, LanguageSupport.Languages.Mastery_Efficiency_Harvesting_Title, LanguageSupport.Languages.Mastery_Efficiency_Harvesting_Desc, XMaterial.WOODEN_HOE.parseMaterial(), MasteryType.EFFICIENCY),
    Pacifist(2, LanguageSupport.Languages.Mastery_Efficiency_Pacifist_Title, LanguageSupport.Languages.Mastery_Efficiency_Pacifist_Desc, XMaterial.WHITE_WOOL.parseMaterial(), MasteryType.EFFICIENCY),
    CriticalStrikes(3, LanguageSupport.Languages.Mastery_Brutality_CriticalStrikes_Title, LanguageSupport.Languages.Mastery_Brutality_CriticalStrikes_Desc, XMaterial.GOLDEN_SWORD.parseMaterial(), MasteryType.BRUTALITY),
    Power(4, LanguageSupport.Languages.Mastery_Brutality_Power_Title, LanguageSupport.Languages.Mastery_Brutality_Power_Desc, Material.BLAZE_POWDER, MasteryType.BRUTALITY),
    Glory(5, LanguageSupport.Languages.Mastery_Brutality_Glory_Title, LanguageSupport.Languages.Mastery_Brutality_Glory_Desc, Material.DIAMOND_SWORD, MasteryType.BRUTALITY),
    Precision(6, LanguageSupport.Languages.Mastery_Finesse_Precision_Title, LanguageSupport.Languages.Mastery_Finesse_Precision_Desc, XMaterial.ENDER_EYE.parseMaterial(), MasteryType.FINESSE),
    Exploit(7, LanguageSupport.Languages.Mastery_Finesse_Exploit_Title, LanguageSupport.Languages.Mastery_Finesse_Exploit_Desc, Material.GOLD_INGOT, MasteryType.FINESSE),
    Reap(8, LanguageSupport.Languages.Mastery_Finesse_Reap_Title, LanguageSupport.Languages.Mastery_Finesse_Reap_Desc, Material.ENDER_PEARL, MasteryType.FINESSE),
    Mining(9, LanguageSupport.Languages.Mastery_Efficiency_Mining_Title, LanguageSupport.Languages.Mastery_Efficiency_Mining_Desc, Material.DIAMOND_ORE, MasteryType.EFFICIENCY),
    BruteForce(10, LanguageSupport.Languages.Mastery_Brutality_BruteForce_Title, LanguageSupport.Languages.Mastery_Brutality_BruteForce_Desc, Material.DIAMOND_AXE, MasteryType.BRUTALITY),
    Adriot(11, LanguageSupport.Languages.Mastery_Finesse_Adriot_Title, LanguageSupport.Languages.Mastery_Finesse_Adriot_Desc, Material.ANVIL, MasteryType.FINESSE),
    Regeneration(12, LanguageSupport.Languages.Mastery_Efficiency_Regeneration_Title, LanguageSupport.Languages.Mastery_Efficiency_Regeneration_Desc, Material.GOLDEN_APPLE, MasteryType.EFFICIENCY),
    ThickSkin(13, LanguageSupport.Languages.Mastery_Brutality_ThickSkin_Title, LanguageSupport.Languages.Mastery_Brutality_ThickSkin_Desc, Material.DIAMOND_CHESTPLATE, MasteryType.BRUTALITY),
    Serration(14, LanguageSupport.Languages.Mastery_Finesse_Serration_Title, LanguageSupport.Languages.Mastery_Finesse_Serration_Desc, Material.REDSTONE, MasteryType.FINESSE);

    int tag;
    LanguageSupport.Languages title;
    LanguageSupport.Languages desc;
    Material mat;
    MasteryType type;

    private Mastery(int tag, LanguageSupport.Languages title, LanguageSupport.Languages desc, Material mat, MasteryType type) {
        this.tag = tag;
        this.title = title;
        this.desc = desc;
        this.mat = mat;
        this.type = type;
    }

    public int getTag() {
        return this.tag;
    }

    public MasteryType getType() {
        return this.type;
    }

    public ItemStack getUpgradeItem(Player p) {
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        ItemStack i11 = new ItemStack(this.mat);
        ItemMeta i11m = i11.getItemMeta();
        i11m.setDisplayName(Skills.getLang().parseFirstString(this.title));
        ArrayList<String> i11l = new ArrayList<String>();
        i11l = LoreUtil.addLore(Skills.getLang().parseFirstString(this.desc), i11l, ChatColor.YELLOW);
        i11l.add(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Masteries_Level)) + info.getMasteryLevel(this));
        i11l.add(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Guis_Masteries_Cost)) + this.getCost(info));
        i11m.setLore(i11l);
        i11.setItemMeta(i11m);
        return i11;
    }

    public int getCost(PlayerInfo info) {
        int multiplier = SkillsConfig.ConfigOption.MASTERY_COST.getInt();
        int cost = (info.getMasteryLevel(this) + 1) * multiplier;
        return cost;
    }

    public static Mastery fromTag(int type) {
        Mastery[] masteryArray = Mastery.values();
        int n = masteryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mastery mastery = masteryArray[n2];
            if (mastery == null) break;
            if (mastery.tag == type) {
                return mastery;
            }
            ++n2;
        }
        return null;
    }

    public LanguageSupport.Languages getTitle() {
        return this.title;
    }

    public LanguageSupport.Languages getDesc() {
        return this.desc;
    }

    public Material getMat() {
        return this.mat;
    }

    public boolean isEnabled() {
        switch (this) {
            case Adriot: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_ADRIOT.getBoolean();
            }
            case BruteForce: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_BRUTEFORCE.getBoolean();
            }
            case CriticalStrikes: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_CRITICALSTRIKES.getBoolean();
            }
            case Exploit: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_EXPLOIT.getBoolean();
            }
            case Glory: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_GLORY.getBoolean();
            }
            case Harvesting: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_HARVESTING.getBoolean();
            }
            case Logging: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_LOGGING.getBoolean();
            }
            case Mining: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_MINING.getBoolean();
            }
            case Pacifist: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_PACIFIST.getBoolean();
            }
            case Power: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_POWER.getBoolean();
            }
            case Precision: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_PRECISION.getBoolean();
            }
            case Reap: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_REAP.getBoolean();
            }
            case Regeneration: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_REGENERATION.getBoolean();
            }
            case Serration: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_SERRATION.getBoolean();
            }
            case ThickSkin: {
                return SkillsConfig.ConfigOption.MASTERY_ENABLED_THICKSKIN.getBoolean();
            }
        }
        return false;
    }
}

