/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skilltype.SkillType;

public class SkillsConfig {
    private static Skills plugin;
    private static final ArrayList<String> types;

    static {
        types = new ArrayList<String>(){
            {
                this.add("swordsman");
                this.add("devourer");
                this.add("firemage");
                this.add("mage");
                this.add("pyro");
                this.add("juggernaut");
                this.add("arbalist");
                this.add("vampire");
                this.add("eidolon");
                this.add("none");
            }
        };
    }

    public SkillsConfig(Skills plugin) {
        SkillsConfig.plugin = plugin;
        plugin.getConfig().options().copyDefaults(false);
        plugin.saveConfig();
        ConfigOption[] configOptionArray = ConfigOption.values();
        int n = configOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigOption option = configOptionArray[n2];
            option.load();
            option.save();
            ++n2;
        }
    }

    public void reloadConfig() {
        plugin.reloadConfig();
        plugin.getConfig().options().copyDefaults(false);
        plugin.saveConfig();
        ConfigOption[] configOptionArray = ConfigOption.values();
        int n = configOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigOption option = configOptionArray[n2];
            option.load();
            option.save();
            ++n2;
        }
    }

    public static enum ConfigOption {
        LANG("lang", "eng"),
        PLAYERDATA_SAVE_INTERVAL_SECONDS("playerdata-save-interval-seconds", 300),
        ENABLED_WORLDS("enabled-worlds", new ArrayList<String>(){
            {
                this.add("world");
            }
        }),
        USE_ACTIONBAR("use-actionbar", true),
        SOUL_LOSS_DISABLED_WORLDS("soul-lose-disabled-worlds", new ArrayList<String>(){
            {
                this.add("World_With_No_Soul_Lost");
                this.add("Derp_World");
            }
        }),
        SOUL_GAIN_DISABLED_WORLDS("soul-gain-disabled-worlds", new ArrayList<String>(){
            {
                this.add("World_With_No_Soul_Gain");
                this.add("Derp_World");
            }
        }),
        XP_GAIN_DISABLED_WORLDS("xp-gain-disabled-worlds", new ArrayList<String>(){
            {
                this.add("World_With_No_XP_Gain");
                this.add("Derp_World");
            }
        }),
        LOG_DEBUG("is-debug", false),
        BONUS_XP_MOB_NAMES("mob-name-bonus-xp", new ArrayList<String>(){
            {
                this.add("&4A_Mob,30");
            }
        }),
        BONUS_SOUL_MOB_TYPES("special-soul-gain-cases", new ArrayList<String>(){
            {
                this.add("PLAYER,2");
                this.add("WITHER,10");
                this.add("ENDER_DRAGON,100");
            }
        }),
        SPAWNER_SUPPORT_XP("spawner-support", true),
        SPAWNER_XP_PERCENT_DECREASE("spawner-percentage-decrease", 0.1),
        SPAWNER_AWARD_SOUL("spawner-award-soul", false),
        ITEMS_THAT_PREVENT_SKILLACTIVATION("items-that-prevent-skillactivation", new ArrayList<String>(){
            {
                this.add("FLINT_AND_STEEL");
                this.add("WOOD_HOE");
                this.add("WOODEN_HOE");
                this.add("STONE_HOE");
                this.add("GOLD_HOE");
                this.add("DIAMOND_HOE");
                this.add("IRON_HOE");
            }
        }),
        LEVEL_REQUIREMENT_EQN("levelRequirementEquation", "currlevel*100+1"),
        LEVEL_MAX("max-level", 100),
        STAT_MAX("stat-max", 100),
        MIN_SOUL_COUNT("minimum-soul-count", 0),
        SOULS_LOST_ON_DEATH("souls-lost-upon-death", 5),
        SKILL_CHANGE_COOLDOWN("skill-change-cooldown", 60),
        PERFORM_COMMAND_SELECT("perform-commands-upon-skill-select", false),
        COMMANDS_TO_PERFORM_SELECT_PLAYER("commands-to-perform-upon-skill-select.%skill%.player", new ArrayList<String>(){
            {
                this.add("me has picked %skill%");
                this.add("spawn");
            }
        }),
        COMMANDS_TO_PERFORM_SELECT_CONSOLE("commands-to-perform-upon-skill-select.%skill%.console", new ArrayList<String>(){
            {
                this.add("kit %player% %skill%");
            }
        }),
        PERFORM_COMMAND_CHANGE("perform-commands-upon-skill-change", false),
        COMMANDS_TO_PERFORM_CHANGE_PLAYER("commands-to-perform-upon-skill-change.%skill%.player", new ArrayList<String>(){
            {
                this.add("me has picked %skill%");
                this.add("spawn");
            }
        }),
        COMMANDS_TO_PERFORM_CHANGE_CONSOLE("commands-to-perform-upon-skill-change.%skill%.console", new ArrayList<String>(){
            {
                this.add("kit %player% change%skill%");
            }
        }),
        LEVEL_UP_STATPOINT_THRESHOLD_REWARDS("level-up-statpoint-reward-thresholds", new ArrayList<String>(){
            {
                this.add("0:2");
                this.add("10:4");
                this.add("40:6");
                this.add("60:8");
                this.add("80:10");
                this.add("100:20");
            }
        }),
        PERFORM_LEVEL_UP_COMMANDS("perform-commands-upon-level-up", false),
        LEVEL_UP_COMMANDS_TO_PERFORM_PLAYER("commands-to-perform-on-level-up.player", new ArrayList<String>(){
            {
                this.add("me has leveled up to %level%!");
            }
        }),
        LEVEL_UP_COMMANDS_TO_PERFORM_CONSOLE("commands-to-perform-on-level-up.console", new ArrayList<String>(){
            {
                this.add("kit levelup %player%");
            }
        }),
        HEALTH_SCALING("%skill%.health-scaling", "20+lvl*1.5"),
        SCALING_SWORDSMAN_MAXENERGY("scalings.swordsman.max-energy", "20+lvl"),
        SCALING_DEVOURER_MAXENERGY("scalings.devourer.max-energy", "20+lvl"),
        SCALING_MAGE_MAXMANA("scalings.mage.max-mana", "20+lvl"),
        SCALING_JUGGERNAUT_MAXENERGY("scalings.juggernaut.max-energy", "20+lvl"),
        SCALING_VAMPIRE_MAXBLOOD("scalings.vampire.max-blood", "20+lvl+bloodwell*7"),
        SCALING_EIDOLON_MAXIMBALANCE("scalings.eidolon.max-imbalance", "100"),
        SCALING_SWORDSMAN_PASSIVE("scalings.swordsman.passive", "(str*2)+1"),
        SCALING_SWORDSMAN_DODGE("scalings.swordsman.dodge", "dex/7+(lvl*5)"),
        SCALING_SWORDSMAN_PARRY("scalings.swordsman.parry", "dex/5+lvl*2"),
        SCALING_SWORDSMAN_PIERCE("scalings.swordsman.pierce", "str/2+lvl*3"),
        SCALING_SWORDSMAN_THOUSANDCUTS("scalings.swordsman.thousandcuts", "(lvl*2)+str/10"),
        SCALING_DEVOURER_PASSIVE("scalings.devourer.passive", "str/20 + 1"),
        SCALING_DEVOURER_EVOLVEGLIDERS("scalings.devourer.evolvegliders", "lvl"),
        SCALING_DEVOURER_EVOLVECLOAK("scalings.devourer.evolvecloak", "dex/4"),
        SCALING_DEVOURER_EVOLVESADISM("scalings.devourer.evolvesadism", "dex/3+lvl"),
        SCALING_DEVOURER_CONSUME("scalings.devourer.consume.main", "lvl*3+dex/10"),
        SCALING_DEVOURER_CONSUME_HEALTH_BONUS("scalings.devourer.consume.victim-health-bonus-damage", "(victimmaxhp-victimhp)/5"),
        SCALING_MAGE_PASSIVE("scalings.mage.passive", "int/10+1"),
        SCALING_MAGE_REFLECT("scalings.mage.reflect", "lvl*2"),
        SCALING_MAGE_EXPLOSIONSPELL("scalings.mage.explosionspell", "int/2+lvl*10"),
        SCALING_MAGE_HEALSPELL("scalings.mage.healspell", "lvl"),
        SCALING_MAGE_ENERGYFLUX("scalings.mage.energyflux", "1+lvl*2+int/10"),
        SCALING_FIREMAGE_PASSIVE("scalings.firemage.passive", "int/20+1"),
        SCALING_FIREMAGE_ABSORBENERGY("scalings.firemage.absorbenergy", "lvl+int/10"),
        SCALING_FIREMAGE_PHOENIXESSENCE("scalings.firemage.phoenixessence", "int/9+lvl*2"),
        SCALING_FIREMAGE_BLACKFIRE("scalings.firemage.blackfire", "lvl+str/20"),
        SCALING_FIREMAGE_INFERNO("scalings.firemage.inferno", "lvl*2+int/5"),
        SCALING_JUGGERNAUT_PASSIVE("scalings.juggernaut.passive", "def/2+1"),
        SCALING_JUGGERNAUT_HEAVYSTRIKES("scalings.juggernaut.heavystrikes", "def+lvl*5"),
        SCALING_JUGGERNAUT_STONESKIN("scalings.juggernaut.stoneskin", "lvl"),
        SCALING_JUGGERNAUT_AEGISPROTECTION("scalings.juggernaut.aegisprotection", "10-lvl"),
        SCALING_JUGGERNAUT_THROW("scalings.juggernaut.throw", "str/20+lvl*3"),
        SCALING_ARBALIST_PASSIVE("scalings.arbalist.passive", "lvl"),
        SCALING_ARBALIST_EXECUTE("scalings.arbalist.execute", "dex/6+lvl*4"),
        SCALING_ARBALIST_DUALARROW("scalings.arbalist.dualarrow", "def/20+lvl"),
        SCALING_ARBALIST_BARBEDARROW("scalings.arbalist.barbedarrow", "str/30+lvl/2"),
        SCALING_ARBALIST_FIRECROSSBOW("scalings.arbalist.firecrossbow", "7-lvl*2"),
        SCALING_ARBALIST_MAXENERGY("scalings.arbalist.max-energy", "20"),
        SCALING_VAMPIRE_PASSIVE("scalings.vampire.passive", "str/5+1"),
        SCALING_VAMPIRE_BLOODLUST("scalings.vampire.bloodlust", "str/7+lvl*2"),
        SCALING_VAMPIRE_BLOODWELL("scalings.vampire.bloodwell", "int/4+lvl*2"),
        SCALING_VAMPIRE_BLEED("scalings.vampire.bleed", "str/10+lvl"),
        SCALING_VAMPIRE_ETERNALDARKNESS("scalings.vampire.eternaldarkness", "1+lvl+int/20"),
        SCALING_EIDOLON_PASSIVE("scalings.eidolon.passive", "int/10+1"),
        SCALING_EIDOLON_PURIFY_DAMAGE("scalings.eidolon.purify.damage", "str/15+lvl/2"),
        SCALING_EIDOLON_PURIFY_MAX("scalings.eidolon.max", "int/6+lvl*4"),
        SCALING_EIDOLON_SPIRITFIRE_LIGHT("scalings.eidolon.spiritfire.light", "str/7+lvl*3"),
        SCALING_EIDOLON_SPIRITFIRE_DARK("scalings.eidolon.spiritfire.dark", "6-lvl"),
        SCALING_EIDOLON_SPECTRE_COOLDOWNS("scalings.eidolon.spectre.cooldowns", "45-(lvl*5)"),
        SCALING_EIDOLON_SPECTRE_DARKATTACK("scalings.eidolon.spectre.darkattack", "45-(lvl*5)"),
        SCALING_EIDOLON_SPECTRE_SPEED("scalings.eidolon.spectre.speed", "def/30"),
        SCALING_EIDOLON_DEFILE("scalings.eidolon.defile.damage", "lvl*8+(int/2)+5"),
        SCALING_EIDOLON_DEFILE_TIME("scalings.eidolon.defile.time", "lvl*3"),
        SWORDSMAN_THOUSANDCUTS_ENERGY_COST("active-costs-and-cooldowns.thousandcuts.cost", 20),
        SWORDSMAN_THOUSANDCUTS_COOLDOWN("active-costs-and-cooldowns.thousandcuts.cooldown", 30),
        DEVOURER_CONSUME_ENERGY_COST("active-costs-and-cooldowns.consume.cost", 20),
        DEVOURER_CONSUME_COOLDOWN("active-costs-and-cooldowns.consume.cooldown", 30),
        MAGE_ENERGYFLUX_ENERGY_COST("active-costs-and-cooldowns.energyflux.cost", 7),
        MAGE_ENERGYFLUX_COOLDOWN("active-costs-and-cooldowns.energyflux.cooldown", 0),
        FIREMAGE_INFERNO_ENERGY_COST("active-costs-and-cooldowns.inferno.cost", 5),
        FIREMAGE_INFERNO_COOLDOWN("active-costs-and-cooldowns.inferno.cooldown", 15),
        JUGGERNAUT_THROW_ENERGY_COST("active-costs-and-cooldowns.throw.cost", 20),
        JUGGERNAUT_THROW_COOLDOWN("active-costs-and-cooldowns.throw.cooldown", 30),
        ARBALIST_FIRECROSSBOW_ENERGY_COST("active-costs-and-cooldowns.firecrossbow.cost", 0),
        VAMPIRE_ETERNALDARKNESS_ENERGY_COST("active-costs-and-cooldowns.eternaldarkness.cost", 0),
        VAMPIRE_ETERNALDARKNESS_COOLDOWN("active-costs-and-cooldowns.eternaldarkness.cooldown", 30),
        EIDOLON_DEFILE_ENERGY_COST("active-costs-and-cooldowns.defile.cost", 0),
        EIDOLON_DEFILE_COOLDOWN("active-costs-and-cooldowns.defile.cooldown", 30),
        MASTERY_COST("mastery-cost", 20),
        MASTERY_MAX("mastery-max", 5),
        MASTERY_ENABLED_LOGGING("mastery-enabled.logging", true),
        MASTERY_ENABLED_HARVESTING("mastery-enabled.harvesting", true),
        MASTERY_ENABLED_PACIFIST("mastery-enabled.pacifist", true),
        MASTERY_ENABLED_CRITICALSTRIKES("mastery-enabled.criticalstrikes", true),
        MASTERY_ENABLED_POWER("mastery-enabled.power", true),
        MASTERY_ENABLED_GLORY("mastery-enabled.glory", true),
        MASTERY_ENABLED_PRECISION("mastery-enabled.precision", true),
        MASTERY_ENABLED_EXPLOIT("mastery-enabled.exploit", true),
        MASTERY_ENABLED_REAP("mastery-enabled.reap", true),
        MASTERY_ENABLED_MINING("mastery-enabled.mining", true),
        MASTERY_ENABLED_BRUTEFORCE("mastery-enabled.bruteforce", true),
        MASTERY_ENABLED_ADRIOT("mastery-enabled.adriot", true),
        MASTERY_ENABLED_REGENERATION("mastery-enabled.regeneration", true),
        MASTERY_ENABLED_THICKSKIN("mastery-enabled.thickskin", true),
        MASTERY_ENABLED_SERRATION("mastery-enabled.serration", true),
        IS_PERSISTENT_ACTIONBAR("persistentActionBar", true),
        SWORDSMAN_DODGE_COST("base-costs.swordsman.dodge", "100*(lvl+1)"),
        SWORDSMAN_PARRY_COST("base-costs.swordsman.parry", "100*(lvl+1)"),
        SWORDSMAN_PIERCE_COST("base-costs.swordsman.pierce", "100*(lvl+1)"),
        SWORDSMAN_THOUSANDCUTS_COST("base-costs.swordsman.thousandcuts", "300*(lvl+1)"),
        DEVOURER_EVOLVEGLIDERS_COST("base-costs.devourer.evolvegliders", "100*(lvl+1)"),
        DEVOURER_EVOLVECLOAK_COST("base-costs.devourer.evolvecloak", "100*(lvl+1)"),
        DEVOURER_EVOLVESADISM_COST("base-costs.devourer.evolvesadism", "100*(lvl+1)"),
        DEVOURER_CONSUME_COST("base-costs.devourer.consume", "300*(lvl+1)"),
        MAGE_REFLECT_COST("base-costs.mage.reflect", "100*(lvl+1)"),
        MAGE_EXPLOSIONSPELL_COST("base-costs.mage.explosionspell", "100*(lvl+1)"),
        MAGE_HEALSPELL_COST("base-costs.mage.healspell", "100*(lvl+1)"),
        MAGE_ENERGYFLUX_COST("base-costs.mage.energyflux", "300*(lvl+1)"),
        FIREMAGE_ABSORBENERGY_COST("base-costs.firemage.absorbenergy", "100*(lvl+1)"),
        FIREMAGE_PHOENIXESSENCE_COST("base-costs.firemage.phoenixessence", "100*(lvl+1)"),
        FIREMAGE_BLACKFIRE_COST("base-costs.firemage.blackfire", "100*(lvl+1)"),
        FIREMAGE_INFERNO_COST("base-costs.firemage.inferno", "300*(lvl+1)"),
        JUGGERNAUT_HEAVYSTRIKES_COST("base-costs.juggernaut.heavystrikes", "100*(lvl+1)"),
        JUGGERNAUT_STONESKIN_COST("base-costs.juggernaut.stoneskin", "100*(lvl+1)"),
        JUGGERNAUT_AEGISPROTECTION_COST("base-costs.juggernaut.aegisprotection", "100*(lvl+1)"),
        JUGGERNAUT_THROW_COST("base-costs.juggernaut.throw", "300*(lvl+1)"),
        ARBALIST_EXECUTE_COST("base-costs.arbalist.execute", "100*(lvl+1)"),
        ARBALIST_DUALARROW_COST("base-costs.arbalist.dualarrow", "100*(lvl+1)"),
        ARBALIST_BARBEDARROW_COST("base-costs.arbalist.barbedarrow", "100*(lvl+1)"),
        ARBALIST_FIRECROSSBOW_COST("base-costs.arbalist.firecrossbow", "300*(lvl+1)"),
        VAMPIRE_BLOODLUST_COST("base-costs.vampire.bloodlust", "100*(lvl+1)"),
        VAMPIRE_BLOODWELL_COST("base-costs.vampire.bloodwell", "100*(lvl+1)"),
        VAMPIRE_BLEED_COST("base-costs.vampire.bleed", "100*(lvl+1)"),
        VAMPIRE_ETERNALDARKNESS_COST("base-costs.vampire.eternaldarkness", "300*(lvl+1)"),
        EIDOLON_PURIFY_COST("base-costs.eidolon.purify", "100*(lvl+1)"),
        EIDOLON_SPIRITFIRE_COST("base-costs.eidolon.spiritfire", "100*(lvl+1)"),
        EIDOLON_SPECTRE_COST("base-costs.eidolon.spectre", "100*(lvl+1)"),
        EIDOLON_DEFILE_COST("base-costs.eidolon.defile", "300*(lvl+1)"),
        SCALING_SWORDSMAN_ENERGY_REGEN("scalings.swordsman.energy-regen-per-sec", "1+0.05*lvl"),
        SCALING_DEVOURER_ENERGY_REGEN("scalings.devourer.energy-regen-per-sec", "1+0.05*lvl"),
        SCALING_MAGE_MANA_REGEN("scalings.mage.mana-regen-per-sec", "1+0.04*lvl"),
        SCALING_JUGGERNAUT_ENERGY_REGEN("scalings.juggernaut.energy-regen-per-sec", "1+0.05*lvl"),
        SCALING_VAMPIRE_BLOOD_DROP_RATE("scalings.vampire.blood-lost-per-sec", "2"),
        SCALING_EIDOLON_IMBALANCE_RATE("scalings.eidolon.imbalance-per-sec", "1"),
        SCALING_ARBALIST_ENERGY_REGEN("scalings.arbalist.energy-regen-per-sec", "1+0.05*lvl"),
        STATS_ALLOW_RESET("stats.allow-reset", true),
        STATS_RESET_COST("stats.reset-soul-cost", 0),
        PARTY_SOULS_PER_PLAYER("party.souls-per-player-rounded-down", "partysize/5+souls"),
        PARTY_EXP_PER_PLAYER("party.exp-per-player-rounded-down", "partysize/2+exp"),
        PARTY_PARTY_MEMBERS_MAX_RANGE("party.party-player-max-distance", -1),
        MYTHICMOBS_DENY_XP_MARGIN_LOWER("mythicmobs.deny-xp-if-target-lower-level-at", 99999),
        MYTHICMOBS_DENY_SOULS_MARGIN_LOWER("mythicmobs.deny-souls-if-target-lower-level-at", 99999),
        MYTHICMOBS_DENY_XP_MARGIN_HIGHER("mythicmobs.deny-xp-if-target-higher-level-at", 99999),
        MYTHICMOBS_DENY_SOULS_MARGIN_HIGHER("mythicmobs.deny-souls-if-target-higher-level-at", 99999),
        MYTHICMOBS_WORLDS_WITHOUT_LEVEL_MARGIN("mythicmobs.worlds-without-level-margin", new ArrayList<E>());

        private String key;
        private boolean isSkillBased = false;
        private HashMap<String, Object> value = new HashMap();

        private ConfigOption(String key, Object defaultValue) {
            this.key = key;
            if (key.contains("%skill%")) {
                this.isSkillBased = true;
                for (String type : types) {
                    this.value.put(type, this.replaceAllValues(defaultValue, type));
                }
            } else {
                this.value.put("default", defaultValue);
            }
        }

        private Object replaceAllValues(Object obj, String type) {
            if (obj instanceof String) {
                return ((String)obj).replaceAll("%skill%", type);
            }
            if (obj instanceof List) {
                int i = 0;
                while (i < ((List)obj).size()) {
                    ((List)obj).set(i, ((String)((List)obj).get(i)).replaceAll("%skill%", type));
                    ++i;
                }
            }
            return obj;
        }

        public void load() {
            if (!this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key)) {
                    String old;
                    if (this.key.startsWith("base-costs.") && !(old = plugin.getConfig().getString(this.key)).contains("lvl")) {
                        plugin.getConfig().set(this.key, (Object)(String.valueOf(old) + "*(lvl+1)"));
                        plugin.saveConfig();
                    }
                    this.value.put("default", plugin.getConfig().get(this.key));
                }
            } else {
                for (String type : types) {
                    if (!plugin.getConfig().isSet(this.key.replaceAll("%skill%", type))) continue;
                    this.value.put(type, plugin.getConfig().get(this.key.replaceAll("%skill%", type)));
                }
            }
        }

        public void setValue(Object value, SkillType type) {
            if (this.isSkillBased) {
                this.value.put(type.getConfigName(), value);
            }
        }

        public void setValue(Object value) {
            if (!this.isSkillBased) {
                this.value.put("default", value);
            }
        }

        public void save() {
            if (!this.isSkillBased) {
                plugin.getConfig().set(this.key, this.value.get("default"));
                plugin.saveConfig();
            } else {
                for (String type : types) {
                    plugin.getConfig().set(this.key.replaceAll("%skill%", type), this.value.get(type));
                    plugin.saveConfig();
                }
            }
        }

        public boolean getBoolean() {
            if (!this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key)) {
                    return plugin.getConfig().getBoolean(this.key);
                }
                return (Boolean)this.value.get("default");
            }
            Skills.logDebug("Error in config parsing");
            return false;
        }

        public boolean getBoolean(SkillType type) {
            if (this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key.replaceAll("%skill%", type.getConfigName()))) {
                    return plugin.getConfig().getBoolean(this.key.replaceAll("%skill%", type.getConfigName()));
                }
                return (Boolean)this.value.get(type.getConfigName());
            }
            Skills.logDebug("Error in config parsing");
            return false;
        }

        public int getInt() {
            if (!this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key)) {
                    return plugin.getConfig().getInt(this.key);
                }
                plugin.getConfig().set(this.key, this.value);
                plugin.saveConfig();
                return (Integer)this.value.get("default");
            }
            Skills.logDebug("Error in config parsing");
            return 0;
        }

        public int getInt(SkillType type) {
            if (this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key.replaceAll("%skill%", type.getConfigName()))) {
                    return plugin.getConfig().getInt(this.key.replaceAll("%skill%", type.getConfigName()));
                }
                return (Integer)this.value.get(type.getConfigName());
            }
            Skills.logDebug("Error in config parsing");
            return 0;
        }

        public double getDouble() {
            if (!this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key)) {
                    return plugin.getConfig().getDouble(this.key);
                }
                plugin.getConfig().set(this.key, this.value);
                plugin.saveConfig();
                return ((Integer)this.value.get("default")).intValue();
            }
            Skills.logDebug("Error in config parsing");
            return 0.0;
        }

        public double getDouble(SkillType type) {
            if (this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key.replaceAll("%skill%", type.getConfigName()))) {
                    return plugin.getConfig().getDouble(this.key.replaceAll("%skill%", type.getConfigName()));
                }
                return (Double)this.value.get(type.getConfigName());
            }
            Skills.logDebug("Error in config parsing");
            return 0.0;
        }

        public List<String> getStringList() {
            if (!this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key)) {
                    return plugin.getConfig().getStringList(this.key);
                }
                plugin.getConfig().set(this.key, this.value);
                plugin.saveConfig();
                return (List)this.value.get("default");
            }
            Skills.logDebug("Error in config parsing");
            return null;
        }

        public List<String> getStringList(SkillType type) {
            if (this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key.replaceAll("%skill%", type.getConfigName()))) {
                    return plugin.getConfig().getStringList(this.key.replaceAll("%skill%", type.getConfigName()));
                }
                return (List)this.value.get(type.getConfigName());
            }
            Skills.logDebug("Error in config parsing");
            return null;
        }

        public String getString() {
            if (!this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key)) {
                    return plugin.getConfig().getString(this.key);
                }
                plugin.getConfig().set(this.key, this.value);
                plugin.saveConfig();
                return (String)this.value.get("default");
            }
            Skills.logDebug("Error in config parsing");
            return "";
        }

        public String getString(SkillType type) {
            if (this.isSkillBased) {
                if (plugin.getConfig().isSet(this.key.replaceAll("%skill%", type.getConfigName()))) {
                    return plugin.getConfig().getString(this.key.replaceAll("%skill%", type.getConfigName()));
                }
                return (String)this.value.get(type.getConfigName());
            }
            Skills.logDebug("Error in config parsing");
            return "";
        }

        public String getKey() {
            return this.key;
        }
    }
}

