/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import me.leothepro555.skills.damage.HealthAndEnergyManager;
import me.leothepro555.skills.database.Data;
import me.leothepro555.skills.database.DataSerializer;
import me.leothepro555.skills.database.managers.PlayerDataManager;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.interactivegui.InteractiveGUIManager;
import me.leothepro555.skills.level.LevelManager;
import me.leothepro555.skills.main.CommandExecutor;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.masteries.MasteryListener;
import me.leothepro555.skills.party.PartyManager;
import me.leothepro555.skills.serialize.FileSerializeException;
import me.leothepro555.skills.stats.StatMenuManager;
import me.leothepro555.skilltype.SkillSelectorMenuManager;
import me.leothepro555.skilltype.SkillTypeManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Skills
extends JavaPlugin {
    public static LanguageSupport languageManager;
    public static Skills instance;
    public static GsonBuilder gsonBuilder;
    private PlayerDataManager playerDataManager;
    private CommandExecutor commandExecutor;
    private SkillTypeManager skillTypeManager;
    private StatMenuManager statMenuManager;
    private SkillSelectorMenuManager skillSelectorMenuManager;
    private ExternalHandler externalHandler;
    private HealthAndEnergyManager healthAndEnergyManager;
    public SkillsConfig skillsConfig;
    private LevelManager levelManager;
    private static Gson gson;

    static {
        gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Data.class, (Object)new DataSerializer());
        gson = null;
    }

    public void onEnable() {
        instance = this;
        this.skillsConfig = new SkillsConfig(this);
        try {
            languageManager = new LanguageSupport((Plugin)this, SkillsConfig.ConfigOption.LANG.getString());
        }
        catch (FileSerializeException e1) {
            Bukkit.getLogger().info("Could not initiate LanguageSupport. Something went wrong?");
            Bukkit.getLogger().info("Plugin is going to be disabled.");
            this.setEnabled(false);
        }
        this.skillTypeManager = new SkillTypeManager(this);
        this.playerDataManager = new PlayerDataManager(this);
        this.statMenuManager = new StatMenuManager(this);
        this.externalHandler = new ExternalHandler(this);
        this.skillSelectorMenuManager = new SkillSelectorMenuManager(this);
        this.healthAndEnergyManager = new HealthAndEnergyManager(this);
        this.levelManager = new LevelManager(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.levelManager, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InteractiveGUIManager(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.healthAndEnergyManager, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new MasteryListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PartyManager(this), (Plugin)this);
        this.commandExecutor = new CommandExecutor(this);
    }

    public void onDisable() {
        this.playerDataManager.saveAll();
    }

    public static Gson getGson() {
        if (gson == null) {
            gson = gsonBuilder.setPrettyPrinting().excludeFieldsWithModifiers(new int[]{128, 8}).create();
        }
        return gson;
    }

    public static void logDebug(String s) {
        if (SkillsConfig.ConfigOption.LOG_DEBUG.getBoolean()) {
            Bukkit.getLogger().info(s);
        }
    }

    public static void logInfo(String s) {
        Bukkit.getLogger().info("[Skills] " + s);
    }

    public static void logError(String s) {
        Bukkit.getLogger().severe("[Skills][ERROR]: " + s);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("skill") || cmd.getName().equalsIgnoreCase("skills")) {
            if (this.commandExecutor == null) {
                Skills.logDebug("wtf");
                this.commandExecutor = new CommandExecutor(this);
            }
            this.commandExecutor.onCommand(sender, cmd, label, args);
            return true;
        }
        return false;
    }

    public void reloadLanguages() {
        try {
            languageManager = new LanguageSupport((Plugin)Skills.get(), SkillsConfig.ConfigOption.LANG.getString());
        }
        catch (FileSerializeException e1) {
            Bukkit.getLogger().info("Could not initiate LanguageSupport. Something went wrong?");
            Bukkit.getLogger().info("Plugin is going to be disabled.");
        }
    }

    public static Skills get() {
        return instance;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public SkillTypeManager getSkillTypeManager() {
        return this.skillTypeManager;
    }

    public static LanguageSupport getLang() {
        return languageManager;
    }

    public StatMenuManager getStatMenuManager() {
        return this.statMenuManager;
    }

    public SkillSelectorMenuManager getSkillSelectorMenuManager() {
        return this.skillSelectorMenuManager;
    }

    public ExternalHandler getExternalHandler() {
        return this.externalHandler;
    }

    public HealthAndEnergyManager getHealthAndEnergyManager() {
        return this.healthAndEnergyManager;
    }

    public LevelManager getLevelManager() {
        return this.levelManager;
    }
}

