/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.main;

import java.util.ArrayList;
import java.util.HashMap;
import me.leothepro555.skills.commands.CommandChange;
import me.leothepro555.skills.commands.CommandGiveBonus;
import me.leothepro555.skills.commands.CommandImprove;
import me.leothepro555.skills.commands.CommandInfo;
import me.leothepro555.skills.commands.CommandMastery;
import me.leothepro555.skills.commands.CommandPartyAccept;
import me.leothepro555.skills.commands.CommandPartyCreate;
import me.leothepro555.skills.commands.CommandPartyInvite;
import me.leothepro555.skills.commands.CommandPartyLeave;
import me.leothepro555.skills.commands.CommandPartyShow;
import me.leothepro555.skills.commands.CommandRefresh;
import me.leothepro555.skills.commands.CommandReload;
import me.leothepro555.skills.commands.CommandResetPlayer;
import me.leothepro555.skills.commands.CommandSee;
import me.leothepro555.skills.commands.CommandSelect;
import me.leothepro555.skills.commands.CommandSetSkill;
import me.leothepro555.skills.commands.CommandSetSouls;
import me.leothepro555.skills.commands.CommandSetStatPoints;
import me.leothepro555.skills.commands.CommandSetXp;
import me.leothepro555.skills.commands.CommandSetlevel;
import me.leothepro555.skills.commands.CommandShowActiveMessages;
import me.leothepro555.skills.commands.CommandStartSoulBoost;
import me.leothepro555.skills.commands.CommandStartXpBoost;
import me.leothepro555.skills.commands.CommandStat;
import me.leothepro555.skills.commands.CommandTakeBonus;
import me.leothepro555.skills.commands.CommandTop;
import me.leothepro555.skills.commands.SkillsCommand;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandExecutor {
    private Skills plugin;
    HashMap<String, SkillsCommand> commands = new HashMap();
    HashMap<String, SkillsCommand> alias = new HashMap();

    public CommandExecutor(Skills plugin) {
        this.plugin = plugin;
        this.commands.put("help", new CommandHelp());
        this.commands.put("info", new CommandInfo());
        this.commands.put("change", new CommandChange());
        this.commands.put("improve", new CommandImprove());
        this.commands.put("refresh", new CommandRefresh());
        this.commands.put("mastery", new CommandMastery());
        this.commands.put("partyaccept", new CommandPartyAccept());
        this.commands.put("partycreate", new CommandPartyCreate());
        this.commands.put("partyinvite", new CommandPartyInvite());
        this.commands.put("partyleave", new CommandPartyLeave());
        this.commands.put("partyshow", new CommandPartyShow());
        this.commands.put("resetplayer", new CommandResetPlayer());
        this.commands.put("see", new CommandSee());
        this.commands.put("select", new CommandSelect());
        this.commands.put("setlevel", new CommandSetlevel());
        this.commands.put("setskill", new CommandSetSkill());
        this.commands.put("setxp", new CommandSetXp());
        this.commands.put("setsouls", new CommandSetSouls());
        this.commands.put("setstatpoints", new CommandSetStatPoints());
        this.commands.put("startsoulboost", new CommandStartSoulBoost());
        this.commands.put("startxpboost", new CommandStartXpBoost());
        this.commands.put("stats", new CommandStat());
        this.commands.put("showactivemessages", new CommandShowActiveMessages());
        this.commands.put("reload", new CommandReload());
        this.commands.put("top", new CommandTop());
        this.commands.put("givebonus", new CommandGiveBonus());
        this.commands.put("takebonus", new CommandTakeBonus());
        this.alias.put("stat", new CommandStat());
        this.alias.put("masteries", new CommandMastery());
        this.alias.put("setsoul", new CommandSetSouls());
        this.alias.put("setstatpoint", new CommandSetStatPoints());
        this.alias.put("h", new CommandHelp());
        this.alias.put("level", new CommandInfo());
        this.alias.put("sam", new CommandShowActiveMessages());
    }

    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            this.commands.get("help").runCommand(sender, args);
            return;
        }
        SkillsCommand command = null;
        if (!this.commands.containsKey(args[0].toLowerCase())) {
            if (!this.alias.containsKey(args[0].toLowerCase())) {
                this.commands.get("help").runCommand(sender, args);
                return;
            }
            command = this.alias.get(args[0].toLowerCase());
        } else {
            command = this.commands.get(args[0].toLowerCase());
        }
        if (command.hasPermission(sender) || sender.isOp()) {
            command.runCommand(sender, args);
        } else {
            Skills.get();
            sender.sendMessage(Skills.languageManager.parseFirstString(LanguageSupport.Languages.Misc_No_Perm_Error));
        }
    }

    public class CommandHelp
    extends SkillsCommand {
        @Override
        public void runCommand(CommandSender sender, String[] args) {
            Skills plugin = Skills.get();
            ArrayList<String> scs = new ArrayList<String>();
            for (String s : CommandExecutor.this.commands.keySet()) {
                if (!CommandExecutor.this.commands.get(s).hasPermission(sender)) continue;
                scs.add(s);
            }
            int page = 0;
            if (args.length == 2) {
                try {
                    page = Integer.parseInt(args[1]) - 1;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(String.valueOf(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Usage)) + "/skill h [1,2,3,4...]");
                    return;
                }
            }
            sender.sendMessage(ChatColor.GOLD + "============[" + ChatColor.YELLOW + "Skills+" + ChatColor.GOLD + "][" + ChatColor.YELLOW + "Pg. " + (page + 1) + ChatColor.GOLD + "]============");
            boolean maxhit = false;
            int i = 0;
            while (i < 6) {
                if (scs.size() > page * 5 + i) {
                    String cmd = (String)scs.get(page * 5 + i);
                    SkillsCommand command = CommandExecutor.this.commands.get(cmd);
                    sender.sendMessage(ChatColor.AQUA + "/skill " + cmd + " " + command.getDescription());
                } else {
                    maxhit = true;
                }
                ++i;
            }
            if (!maxhit) {
                sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_NextPage).replaceAll("%page%", String.valueOf(page + 2)));
            } else {
                sender.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_No_More_Pages));
            }
        }

        @Override
        public boolean hasPermission(CommandSender sender) {
            return true;
        }

        @Override
        public String getDescription() {
            return Skills.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Help);
        }
    }
}

