/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.level;

import java.util.HashMap;
import java.util.Map;
import me.leothepro555.skills.damage.LastHitManager;
import me.leothepro555.skills.database.managers.PlayerDataManager;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.events.CustomHudChangeEvent;
import me.leothepro555.skills.events.SkillLevelUpEvent;
import me.leothepro555.skills.events.SkillScalingTypeChangeEvent;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.party.Party;
import me.leothepro555.skills.party.PartyManager;
import me.leothepro555.skills.skillsevents.BonusType;
import me.leothepro555.skills.skillsevents.EventManager;
import me.leothepro555.skills.skillsevents.SkillsEvent;
import me.leothepro555.skills.utils.MathEval;
import me.leothepro555.skills.utils.MathUtil;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class LevelManager
implements Listener {
    private Skills plugin;
    private Map<String, Integer> specialMobNames = new HashMap<String, Integer>();
    private Map<String, Integer> specialSoulGainCases = new HashMap<String, Integer>();
    private Map<Integer, Integer> statPointLevelUpThresholds = new HashMap<Integer, Integer>();
    private static final String SPAWNER = "SPAWNER_SPAWNED";

    private int getXpWorth(EntityType type) {
        if (!type.isAlive()) {
            return 0;
        }
        if (type.toString().equals("BAT")) {
            return 0;
        }
        if (type.toString().equals("WITHER")) {
            return 100;
        }
        if (type.toString().equals("ENDER_DRAGON")) {
            return 500;
        }
        if (type.toString().equals("ZOMBIE") || type.toString().equals("SKELETON") || type.toString().equals("CAVE_SPIDER") || type.toString().equals("SPIDER") || type.toString().equals("GHAST") || type.toString().equals("PIGZOMBIE") || type.toString().equals("CREEPER") || type.toString().equals("BLAZE") || type.toString().equals("MAGMA_CUBE") || type.toString().equals("SLIME") || type.toString().equals("GUARDIAN") || type.toString().equals("ENDERMAN") || type.toString().equals("ENDERMITE") || type.toString().equals("HUSK") || type.toString().equals("ILLUSIONER") || type.toString().equals("SHULKER") || type.toString().equals("STRAY") || type.toString().equals("VEX") || type.toString().equals("WITCH") || type.toString().equals("WITHER_SKELETON")) {
            return 5;
        }
        return MathUtil.randInt(1, 3);
    }

    private int getCustomXP(Entity e) {
        String comp = e.getCustomName();
        if (ExternalHandler.isMythicMob(e)) {
            comp = ExternalHandler.getMythicMobName(e);
        }
        if (comp == null) {
            return -1;
        }
        if (this.specialMobNames.containsKey(comp)) {
            return this.specialMobNames.get(comp);
        }
        return -1;
    }

    public LevelManager(Skills plugin) {
        this.plugin = plugin;
        this.load();
    }

    public void load() {
        String[] split;
        this.specialMobNames.clear();
        this.statPointLevelUpThresholds.clear();
        this.specialSoulGainCases.clear();
        for (String entry : SkillsConfig.ConfigOption.BONUS_XP_MOB_NAMES.getStringList()) {
            split = entry.split(",");
            String name = ChatColor.translateAlternateColorCodes((char)'&', (String)split[0]);
            int xp = Integer.parseInt(split[1]);
            this.specialMobNames.put(name, xp);
        }
        for (String entry : SkillsConfig.ConfigOption.LEVEL_UP_STATPOINT_THRESHOLD_REWARDS.getStringList()) {
            split = entry.split(":");
            try {
                int level = Integer.parseInt(split[0]);
                int statReward = Integer.parseInt(split[1]);
                this.statPointLevelUpThresholds.put(level, statReward);
            }
            catch (NumberFormatException e) {
                Skills.logError("Incorrect format for entry " + entry + " for config option " + SkillsConfig.ConfigOption.LEVEL_UP_STATPOINT_THRESHOLD_REWARDS.getKey());
            }
        }
        for (String entry : SkillsConfig.ConfigOption.BONUS_SOUL_MOB_TYPES.getStringList()) {
            try {
                split = entry.split(",");
                String type = split[0];
                int souls = Integer.parseInt(split[1]);
                this.specialSoulGainCases.put(type, souls);
                this.specialSoulGainCases.put(type.toUpperCase(), souls);
            }
            catch (NumberFormatException e) {
                Skills.logError("Incorrect format for entry " + entry + " for config option " + SkillsConfig.ConfigOption.BONUS_SOUL_MOB_TYPES.getKey());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityKill(EntityDeathEvent event) {
        PlayerInfo info;
        BonusType expbonus;
        if (!SkillsConfig.ConfigOption.ENABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            return;
        }
        if (ExternalHandler.isMyPet((Entity)event.getEntity())) {
            return;
        }
        Player killer = LastHitManager.getFinalHitMob(event.getEntity());
        if (killer == null) {
            return;
        }
        int xp = this.getCustomXP((Entity)event.getEntity());
        if (xp == -1 && (xp = event.getDroppedExp()) == 0) {
            xp = this.getXpWorth(event.getEntityType());
        }
        if ((expbonus = (info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)killer)).getBonusType(SkillsEvent.SkillsEventType.EXP)) != null) {
            xp = (int)new MathEval().evaluate(expbonus.getMultiplier().replaceAll("exp", "" + xp).replaceAll("soul", "" + xp));
        }
        if (PartyManager.hasParty(killer.getUniqueId())) {
            Party party = PartyManager.getParty(killer.getUniqueId());
            if (party.members.size() > 1) {
                xp = party.parseBonusXp(xp);
            }
        }
        if (EventManager.isEventOn(SkillsEvent.SkillsEventType.EXP)) {
            xp = (int)((double)xp * EventManager.getEventMultiplier(SkillsEvent.SkillsEventType.EXP));
        }
        if (event.getEntity().hasMetadata(SPAWNER)) {
            xp = (int)((double)xp * SkillsConfig.ConfigOption.SPAWNER_XP_PERCENT_DECREASE.getDouble());
        }
        if (ExternalHandler.isMythicMob((Entity)event.getEntity()) && !SkillsConfig.ConfigOption.MYTHICMOBS_WORLDS_WITHOUT_LEVEL_MARGIN.getStringList().contains(event.getEntity().getWorld().getName())) {
            int level = ExternalHandler.getMythicMobLevel((Entity)event.getEntity());
            int leveldiff = info.getLevel() - level;
            if (SkillsConfig.ConfigOption.MYTHICMOBS_DENY_XP_MARGIN_LOWER.getInt() < leveldiff) {
                xp = 0;
            }
            if (SkillsConfig.ConfigOption.MYTHICMOBS_DENY_XP_MARGIN_HIGHER.getInt() < -leveldiff) {
                xp = 0;
            }
        }
        if ((event.getEntity().hasMetadata(SPAWNER) && SkillsConfig.ConfigOption.SPAWNER_SUPPORT_XP.getBoolean() || !event.getEntity().hasMetadata(SPAWNER)) && !SkillsConfig.ConfigOption.XP_GAIN_DISABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName()) && info.getLevel() < SkillsConfig.ConfigOption.LEVEL_MAX.getInt()) {
            info.setExp(info.getExp() + xp);
            CustomHudChangeEvent chce = new CustomHudChangeEvent(killer);
            Bukkit.getPluginManager().callEvent((Event)chce);
        }
        int souls = 1;
        if (ExternalHandler.isMythicMob((Entity)event.getEntity()) && this.specialSoulGainCases.containsKey(ExternalHandler.getMythicMobName((Entity)event.getEntity()))) {
            souls = this.specialSoulGainCases.get(ExternalHandler.getMythicMobName((Entity)event.getEntity()));
        } else if (this.specialSoulGainCases.containsKey(event.getEntity().getType().toString())) {
            souls = this.specialSoulGainCases.get(event.getEntity().getType().toString());
        }
        BonusType soulbonus = info.getBonusType(SkillsEvent.SkillsEventType.SOUL);
        if (soulbonus != null) {
            souls = (int)new MathEval().evaluate(soulbonus.getMultiplier().replaceAll("exp", "" + souls).replaceAll("soul", "" + souls));
        }
        if (PartyManager.hasParty(killer.getUniqueId())) {
            Party party = PartyManager.getParty(killer.getUniqueId());
            souls = party.parseBonusSouls(souls);
        }
        if (EventManager.isEventOn(SkillsEvent.SkillsEventType.SOUL)) {
            souls = (int)((double)souls * EventManager.getEventMultiplier(SkillsEvent.SkillsEventType.SOUL));
        }
        if (ExternalHandler.isMythicMob((Entity)event.getEntity()) && !SkillsConfig.ConfigOption.MYTHICMOBS_WORLDS_WITHOUT_LEVEL_MARGIN.getStringList().contains(event.getEntity().getWorld().getName())) {
            int level = ExternalHandler.getMythicMobLevel((Entity)event.getEntity());
            int leveldiff = info.getLevel() - level;
            if (SkillsConfig.ConfigOption.MYTHICMOBS_DENY_SOULS_MARGIN_LOWER.getInt() < leveldiff) {
                souls = 0;
            }
            if (SkillsConfig.ConfigOption.MYTHICMOBS_DENY_SOULS_MARGIN_HIGHER.getInt() < -leveldiff) {
                souls = 0;
            }
        }
        if ((event.getEntity().hasMetadata(SPAWNER) && SkillsConfig.ConfigOption.SPAWNER_AWARD_SOUL.getBoolean() || !event.getEntity().hasMetadata(SPAWNER)) && !SkillsConfig.ConfigOption.SOUL_GAIN_DISABLED_WORLDS.getStringList().contains(event.getEntity().getWorld().getName())) {
            info.setSouls(info.getSouls() + souls);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onLevelUp(SkillLevelUpEvent event) {
        if (event.isCancelled()) {
            return;
        }
        PlayerDataManager.levels.put(event.getPlayer().getUniqueId(), event.getNewLevel());
        int highestStatThreshold = 0;
        for (int threshold : this.statPointLevelUpThresholds.keySet()) {
            if (event.getNewLevel() < threshold) continue;
            highestStatThreshold = threshold;
        }
        OfflinePlayer p = event.getPlayer();
        if (p.isOnline()) {
            CustomHudChangeEvent chce = new CustomHudChangeEvent((Player)p);
            Bukkit.getPluginManager().callEvent((Event)chce);
        }
        PlayerInfo info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo(event.getPlayer());
        int gained = this.statPointLevelUpThresholds.get(highestStatThreshold);
        info.setStatpoints(info.getStatpoints() + gained);
        if (p.isOnline()) {
            ((Player)p).sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Gained_StatPoints).replaceAll("%amount%", String.valueOf(gained)));
        }
        if (SkillsConfig.ConfigOption.PERFORM_LEVEL_UP_COMMANDS.getBoolean()) {
            for (String command : SkillsConfig.ConfigOption.LEVEL_UP_COMMANDS_TO_PERFORM_PLAYER.getStringList()) {
                if (!p.isOnline()) continue;
                Bukkit.dispatchCommand((CommandSender)((Player)p), (String)command.replaceAll("%player%", p.getName()).replaceAll("%level%", "" + event.getNewLevel()));
            }
            for (String command : SkillsConfig.ConfigOption.LEVEL_UP_COMMANDS_TO_PERFORM_CONSOLE.getStringList()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replaceAll("%player%", p.getName()).replaceAll("%level%", "" + event.getNewLevel()));
            }
        }
        if (p.isOnline()) {
            ((Player)p).sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Level_Up).replaceAll("%xp%", "" + PlayerInfo.getLevelUpXpForLevel(event.getOldLevel())));
            SkillScalingTypeChangeEvent sstce = new SkillScalingTypeChangeEvent((Player)p, null);
            Bukkit.getPluginManager().callEvent((Event)sstce);
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player p = event.getEntity();
        String w = p.getWorld().getName();
        PlayerInfo info = this.plugin.getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)p);
        if (!SkillsConfig.ConfigOption.SOUL_LOSS_DISABLED_WORLDS.getStringList().contains(w)) {
            int soulslost = SkillsConfig.ConfigOption.SOULS_LOST_ON_DEATH.getInt();
            int minsoul = SkillsConfig.ConfigOption.MIN_SOUL_COUNT.getInt();
            int currsouls = info.getSouls();
            if (currsouls - soulslost >= minsoul) {
                info.setSouls(info.getSouls() - soulslost);
                p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Soul_Loss).replaceAll("%amount%", "" + soulslost));
            } else {
                info.setSouls(0);
                p.sendMessage(Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Soul_Loss).replaceAll("%amount%", "" + soulslost));
            }
        }
    }

    @EventHandler
    public void mobSpawnEvent(CreatureSpawnEvent event) {
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            event.getEntity().setMetadata(SPAWNER, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)""));
        }
    }
}

