/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.external;

import me.leothepro555.skills.damage.CustomPoisonor;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.skillsevents.EventManager;
import me.leothepro555.skills.skillsevents.SkillsEvent;
import me.leothepro555.skills.utils.MathUtil;
import me.leothepro555.skills.utils.TimeUtils;
import me.leothepro555.skills.utils.VersionSupport;
import me.leothepro555.skilltype.EidolonForm;
import me.leothepro555.skilltype.EnergyType;
import me.leothepro555.skilltype.ScalingType;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;

public enum SkillsPlaceholder {
    SKILL,
    LEVEL,
    SOUL,
    XP,
    ENERGY,
    BLOOD,
    MANA,
    IMBALANCE,
    ACTIVECOOLDOWN,
    ENERGYTYPE,
    MAXXP,
    ISXPBOOST,
    ISSOULBOOST,
    XPBOOSTDURATION,
    SOULBOOSTDURATION,
    SOULBOOSTMULTIPLIER,
    XPBOOSTMULTIPLIER,
    XPBONUSDURATION,
    SOULBONUSDURATION,
    SOULBONUSMULTIPLIER,
    XPBONUSMULTIPLIER,
    ENERGYSYMBOL,
    STATUS,
    ENERGYSTRING,
    HEALTH,
    MAXHEALTH;


    public String getMVdWPlaceholderName() {
        return "skills_" + this.toString().toLowerCase();
    }

    public boolean isEqualToPlaceholder(String placeholder) {
        if (placeholder.equalsIgnoreCase(this.getMVdWPlaceholderName())) {
            return true;
        }
        return placeholder.equalsIgnoreCase(this.toString());
    }

    public String getPlaceholderDisplay(PlayerInfo info) {
        return SkillsPlaceholder.getPlaceholderDisplay(this, info);
    }

    public static String getPlaceholderDisplay(SkillsPlaceholder holder, PlayerInfo info) {
        switch (holder) {
            case ACTIVECOOLDOWN: {
                int timeLeft = (int)info.getActiveStatType(ScalingType.ACTIVECD);
                String cdText = ChatColor.RED + timeLeft + "s \u231b";
                if (timeLeft <= 0) {
                    cdText = ChatColor.GREEN + "00 \u231b";
                }
                return cdText;
            }
            case BLOOD: {
                return "" + (int)info.getActiveStatType(ScalingType.ENERGY);
            }
            case ENERGY: {
                return "" + (int)info.getActiveStatType(ScalingType.ENERGY);
            }
            case ENERGYSTRING: {
                ChatColor energyColor = info.getSkill().getEnergyType().getColor();
                String energySymbol = info.getSkill().getEnergyType().getSymbol();
                if (info.getSkill().getEnergyType() == EnergyType.IMBALANCE) {
                    energyColor = ChatColor.YELLOW;
                    if (info.getForm() == EidolonForm.DARK) {
                        energyColor = ChatColor.DARK_RED;
                    }
                }
                String energyTxt = energyColor + (int)info.getActiveStatType(ScalingType.ENERGY) + energySymbol + "/" + (int)info.getScalingType(ScalingType.ENERGY) + energySymbol;
                if (!info.getSkill().getEnergyType().isHasValue()) {
                    energyTxt = energyColor + energySymbol;
                }
                return energyTxt;
            }
            case ENERGYSYMBOL: {
                ChatColor energyColor = info.getSkill().getEnergyType().getColor();
                String energySymbol = info.getSkill().getEnergyType().getSymbol();
                if (info.getSkill().getEnergyType() == EnergyType.IMBALANCE) {
                    energyColor = ChatColor.YELLOW;
                    if (info.getForm() == EidolonForm.DARK) {
                        energyColor = ChatColor.DARK_RED;
                    }
                }
                return energyColor + energySymbol;
            }
            case ENERGYTYPE: {
                return info.getSkill().getEnergyType().toString();
            }
            case HEALTH: {
                return "" + MathUtil.round(info.getPlayer().getHealth(), 1);
            }
            case IMBALANCE: {
                return "" + (int)info.getActiveStatType(ScalingType.ENERGY);
            }
            case ISSOULBOOST: {
                return "" + EventManager.isEventOn(SkillsEvent.SkillsEventType.SOUL);
            }
            case ISXPBOOST: {
                return "" + EventManager.isEventOn(SkillsEvent.SkillsEventType.EXP);
            }
            case LEVEL: {
                return String.valueOf(info.getLevel());
            }
            case MANA: {
                return "" + (int)info.getActiveStatType(ScalingType.ENERGY);
            }
            case MAXHEALTH: {
                return "" + MathUtil.round(VersionSupport.getMaxHealth((LivingEntity)info.getPlayer()), 1);
            }
            case MAXXP: {
                return "" + PlayerInfo.getLevelUpXpForLevel(info.getLevel());
            }
            case SKILL: {
                return Skills.getLang().parseFirstString(info.getSkill().getLanguageName());
            }
            case SOUL: {
                return String.valueOf(info.getSouls());
            }
            case SOULBOOSTDURATION: {
                if (!EventManager.isEventOn(SkillsEvent.SkillsEventType.SOUL)) {
                    return Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Placeholder_Boost_Not_On);
                }
                return "" + EventManager.getDisplayTimeLeftMins(SkillsEvent.SkillsEventType.SOUL);
            }
            case SOULBOOSTMULTIPLIER: {
                return "" + EventManager.getEventMultiplier(SkillsEvent.SkillsEventType.SOUL);
            }
            case STATUS: {
                String statusTxt = ChatColor.GREEN + "\u2764";
                if (CustomPoisonor.isPoisoned((LivingEntity)info.getPlayer())) {
                    statusTxt = ChatColor.DARK_PURPLE + "\u2623";
                }
                return statusTxt;
            }
            case XP: {
                return String.valueOf(info.getExp());
            }
            case XPBOOSTDURATION: {
                if (!EventManager.isEventOn(SkillsEvent.SkillsEventType.EXP)) {
                    return Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Placeholder_Boost_Not_On);
                }
                return "" + EventManager.getDisplayTimeLeftMins(SkillsEvent.SkillsEventType.EXP);
            }
            case XPBOOSTMULTIPLIER: {
                return "" + EventManager.getEventMultiplier(SkillsEvent.SkillsEventType.SOUL);
            }
            case SOULBONUSDURATION: {
                if (info.getBonusType(SkillsEvent.SkillsEventType.SOUL) == null || !info.getBonusType(SkillsEvent.SkillsEventType.SOUL).isActive()) {
                    return Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Placeholder_Bonus_Not_On);
                }
                return TimeUtils.parseTimeSeconds(info.getBonusType(SkillsEvent.SkillsEventType.SOUL).getTimeLeftInSeconds());
            }
            case SOULBONUSMULTIPLIER: {
                if (info.getBonusType(SkillsEvent.SkillsEventType.SOUL) == null || !info.getBonusType(SkillsEvent.SkillsEventType.SOUL).isActive()) {
                    return Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Placeholder_Bonus_Not_On);
                }
                return info.getBonusType(SkillsEvent.SkillsEventType.SOUL).getMultiplier();
            }
            case XPBONUSDURATION: {
                if (info.getBonusType(SkillsEvent.SkillsEventType.EXP) == null || !info.getBonusType(SkillsEvent.SkillsEventType.EXP).isActive()) {
                    return Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Placeholder_Bonus_Not_On);
                }
                return TimeUtils.parseTimeSeconds(info.getBonusType(SkillsEvent.SkillsEventType.EXP).getTimeLeftInSeconds());
            }
            case XPBONUSMULTIPLIER: {
                if (info.getBonusType(SkillsEvent.SkillsEventType.EXP) == null || !info.getBonusType(SkillsEvent.SkillsEventType.EXP).isActive()) {
                    return Skills.getLang().parseFirstString(LanguageSupport.Languages.Misc_Placeholder_Bonus_Not_On);
                }
                return info.getBonusType(SkillsEvent.SkillsEventType.EXP).getMultiplier();
            }
        }
        return null;
    }
}

