/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.external;

import java.util.HashMap;
import java.util.Map;
import me.leothepro555.skills.external.ActionbarAPIManager;
import me.leothepro555.skills.external.CitizensManager;
import me.leothepro555.skills.external.FactionsManager;
import me.leothepro555.skills.external.KingdomsManager;
import me.leothepro555.skills.external.MVdWPlaceholderManager;
import me.leothepro555.skills.external.MyPetManager;
import me.leothepro555.skills.external.MythicMobsManager;
import me.leothepro555.skills.external.ParticleLIBManager;
import me.leothepro555.skills.external.PlaceholderAPIManager;
import me.leothepro555.skills.external.ResidenceManager;
import me.leothepro555.skills.external.SpartanAntiCheatManager;
import me.leothepro555.skills.external.WorldGuardManager;
import me.leothepro555.skills.main.Skills;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ExternalHandler {
    private static Map<String, Object> managers = new HashMap<String, Object>();
    private Skills plugin;

    public ExternalHandler(Skills plugin) {
        this.plugin = plugin;
        this.addManager("ActionBarAPI", ActionbarAPIManager.class);
        this.addManager("Citizens", CitizensManager.class);
        this.addManager("Factions", FactionsManager.class);
        this.addManager("Kingdoms", KingdomsManager.class);
        this.addManager("Residence", ResidenceManager.class);
        this.addManager("PlaceholderAPI", PlaceholderAPIManager.class);
        this.addManager("MVdWPlaceholderAPI", MVdWPlaceholderManager.class);
        this.addManager("ParticleLIBManager", ParticleLIBManager.class);
        this.addManager("Spartan", SpartanAntiCheatManager.class);
        this.addManager("MythicMobs", MythicMobsManager.class);
        this.addManager("MyPet", MyPetManager.class);
    }

    public static boolean isMyPet(Entity e) {
        if (!ExternalHandler.isSoftdependPresent(MyPetManager.class)) {
            return false;
        }
        return MyPetManager.isMyPet(e);
    }

    public static boolean isCitizen(Entity e) {
        if (!ExternalHandler.isSoftdependPresent(CitizensManager.class)) {
            return false;
        }
        return CitizensManager.isCitizen(e);
    }

    private static boolean isSoftdependPresent(String string) {
        return managers.containsKey(string);
    }

    private static boolean isSoftdependPresent(Class manager) {
        for (Object m : managers.values()) {
            if (!manager.isInstance(m)) continue;
            return true;
        }
        return false;
    }

    private void addManager(String plugin, Class manager) {
        if (Bukkit.getPluginManager().getPlugin(plugin) == null) {
            Skills.logInfo(String.valueOf(plugin) + " not found.");
            return;
        }
        Object managerInst = null;
        try {
            managerInst = manager.newInstance();
        }
        catch (Throwable e) {
            managerInst = null;
            Skills.logError(String.valueOf(plugin) + " found, but Skills has failed to hook into it! Printing error below:");
            e.printStackTrace();
            Skills.logError("This should not affect how Skills works without the hook.");
        }
        if (managerInst != null) {
            this.parseManager(plugin, managerInst);
            if (managerInst instanceof Listener) {
                Bukkit.getPluginManager().registerEvents((Listener)managerInst, (Plugin)this.plugin);
            }
            Skills.logInfo(String.valueOf(plugin) + " found and hooked.");
        }
    }

    public static void sendActionbarMessage(Player p, String msg) {
        if (ExternalHandler.isSoftdependPresent(ActionbarAPIManager.class)) {
            ActionbarAPIManager.sendActionBar(p, msg);
        }
    }

    public void parseManager(String softdepend, Object manager) {
        managers.put(softdepend, manager);
    }

    public static boolean isMythicMob(Entity e) {
        if (!ExternalHandler.isSoftdependPresent(MythicMobsManager.class)) {
            return false;
        }
        return MythicMobsManager.isMythicMob(e);
    }

    public static String getMythicMobName(Entity e) {
        if (!ExternalHandler.isSoftdependPresent(MythicMobsManager.class)) {
            return null;
        }
        return MythicMobsManager.getMythicMobName(e);
    }

    public static int getMythicMobLevel(Entity e) {
        if (!ExternalHandler.isSoftdependPresent(MythicMobsManager.class)) {
            return -1;
        }
        if (!(e instanceof LivingEntity)) {
            return -1;
        }
        return MythicMobsManager.getMythicMobLevel((Entity)((LivingEntity)e));
    }

    public static boolean canFight(Entity e1, Entity e2) {
        if (!(e1 instanceof Player)) {
            return true;
        }
        if (!(e2 instanceof Player)) {
            return true;
        }
        if (ExternalHandler.isSoftdependPresent(CitizensManager.class) && (CitizensManager.isCitizen(e1) || CitizensManager.isCitizen(e2))) {
            return false;
        }
        if (ExternalHandler.isSoftdependPresent(KingdomsManager.class) && !KingdomsManager.canFight(e1, e2)) {
            return false;
        }
        if (ExternalHandler.isSoftdependPresent(FactionsManager.class)) {
            try {
                if (!FactionsManager.canFight(e1, e2)) {
                    return false;
                }
            }
            catch (Throwable e) {
                Skills.logError("Factions support has encountered an error! Skills will now unhook from Factions.");
                e.printStackTrace();
                managers.remove("Factions");
            }
        }
        try {
            if (ExternalHandler.isSoftdependPresent(WorldGuardManager.class) && !WorldGuardManager.canFight(e1, e2)) {
                return false;
            }
        }
        catch (Throwable e) {
            Skills.logError("Worldguard support has encountered an error! Skills will now unhook from worldguard.");
            e.printStackTrace();
            managers.remove("WorldGuard");
        }
        return !ExternalHandler.isSoftdependPresent(ResidenceManager.class) || ResidenceManager.canFight(e1, e2);
    }
}

