/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.events;

import me.leothepro555.skills.damage.CustomPoisonor;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skilltype.EidolonForm;
import me.leothepro555.skilltype.EnergyType;
import me.leothepro555.skilltype.ScalingType;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class CustomHudChangeEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private Player player;
    private String hud;
    private boolean cancelled;

    public CustomHudChangeEvent(Player online) {
        if (ExternalHandler.isCitizen((Entity)online)) {
            return;
        }
        this.player = online;
        PlayerInfo info = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)online);
        String sep = this.getSeparator(info);
        String statusTxt = this.getStatusText(online);
        String energyTxt = this.getEnergyText(info);
        String level = ChatColor.YELLOW + "Lv" + info.getLevel();
        String exp = this.getExpText(info);
        String cdText = this.getCooldownText(info);
        this.hud = String.valueOf(this.getBrace(info, 0)) + statusTxt + sep + energyTxt + sep + level + sep + exp + sep + cdText + this.getBrace(info, 1);
    }

    public String getSeparator(PlayerInfo info) {
        String brace = " | ";
        ChatColor color = ChatColor.AQUA;
        if (info.isActiveReady()) {
            brace = " || ";
            color = ChatColor.RED;
        }
        return color + brace;
    }

    public String getBrace(PlayerInfo info, int side) {
        String brace = " >>>";
        if (side == 0) {
            brace = "<<< ";
        }
        ChatColor color = ChatColor.AQUA;
        if (info.isActiveReady()) {
            brace = " ]=>=-";
            if (side == 0) {
                brace = "-=<=[ ";
            }
            color = ChatColor.RED;
        }
        return color + brace;
    }

    public String getStatusText(Player online) {
        String statusTxt = ChatColor.GREEN + "\u2764";
        if (CustomPoisonor.isPoisoned((LivingEntity)online)) {
            statusTxt = ChatColor.DARK_PURPLE + "\u2623";
        }
        return statusTxt;
    }

    public String getEnergyText(PlayerInfo info) {
        ChatColor energyColor = info.getSkill().getEnergyType().getColor();
        String energySymbol = info.getSkill().getEnergyType().getSymbol();
        if (info.getSkill().getEnergyType() == EnergyType.IMBALANCE) {
            energyColor = ChatColor.YELLOW;
            if (info.getForm() == EidolonForm.DARK) {
                energyColor = ChatColor.DARK_RED;
            }
        }
        String energyTxt = String.valueOf((int)info.getActiveStatType(ScalingType.ENERGY)) + energySymbol + "/" + (int)info.getScalingType(ScalingType.ENERGY) + energySymbol;
        if (!info.getSkill().getEnergyType().isHasValue()) {
            energyTxt = energyColor + energySymbol;
        }
        return energyColor + energyTxt;
    }

    public String getExpText(PlayerInfo info) {
        return ChatColor.AQUA + "[" + ChatColor.YELLOW + info.getExp() + ChatColor.AQUA + "/" + ChatColor.YELLOW + PlayerInfo.getLevelUpXpForLevel(info.getLevel()) + ChatColor.AQUA + "]";
    }

    public String getCooldownText(PlayerInfo info) {
        int timeLeft = (int)info.getActiveStatType(ScalingType.ACTIVECD);
        String cdText = ChatColor.RED + timeLeft + "s \u231b";
        if (timeLeft <= 0) {
            cdText = ChatColor.GREEN + "00 \u231b";
        }
        return cdText;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public String getHud() {
        return this.hud;
    }

    public void setHud(String hud) {
        this.hud = hud;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean arg0) {
        this.cancelled = arg0;
    }
}

