/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.database.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import me.leothepro555.skills.abilities.Ability;
import me.leothepro555.skills.database.Data;
import me.leothepro555.skills.events.EidolonImbalanceChangeEvent;
import me.leothepro555.skills.events.SkillActiveStateChangeEvent;
import me.leothepro555.skills.events.SkillEnergyChangeEvent;
import me.leothepro555.skills.events.SkillImproveEvent;
import me.leothepro555.skills.events.SkillLevelUpEvent;
import me.leothepro555.skills.events.SkillToggleDisableEvent;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import me.leothepro555.skills.masteries.Mastery;
import me.leothepro555.skills.skillsevents.BonusType;
import me.leothepro555.skills.skillsevents.SkillsEvent;
import me.leothepro555.skills.stats.StatType;
import me.leothepro555.skills.utils.Cooldown;
import me.leothepro555.skills.utils.MathUtil;
import me.leothepro555.skilltype.EidolonForm;
import me.leothepro555.skilltype.ScalingType;
import me.leothepro555.skilltype.SkillType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerInfo
extends Data {
    protected UUID uuid;
    protected String id;
    protected String skill = "none";
    protected int level;
    protected int exp;
    protected int souls;
    protected int statstr;
    protected int statint;
    protected int statdex;
    protected int statdef;
    protected int statpoints;
    protected transient ArrayList<Ability> disabledAbilities = new ArrayList();
    protected transient Map<ScalingType, Double> activeScalingTypes = new HashMap<ScalingType, Double>();
    protected transient EidolonForm form = EidolonForm.LIGHT;
    protected String improvementstr;
    protected String masteriesstr;
    protected boolean showReadyMessages = true;
    protected ArrayList<String> bonusList = new ArrayList();
    protected transient boolean activeReady = false;

    public Map<ScalingType, Double> getActiveStatTypes() {
        return this.activeScalingTypes;
    }

    public double getActiveStatType(ScalingType type) {
        if (type == ScalingType.ACTIVECD) {
            return Cooldown.getTimeLeft(this.uuid, "active-" + this.getSkill().getConfigName());
        }
        if (this.activeScalingTypes.containsKey((Object)type)) {
            return this.activeScalingTypes.get((Object)type);
        }
        return -1.0;
    }

    public void setActiveStatType(final ScalingType type, double amount) {
        if (type == ScalingType.ACTIVECD) {
            Cooldown c = new Cooldown(this.uuid, "active-" + this.getSkill().getConfigName(), (int)amount);
            c.start();
            return;
        }
        if (type == ScalingType.ENERGY) {
            final SkillEnergyChangeEvent event = new SkillEnergyChangeEvent(this.getPlayer(), amount);
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        if (!PlayerInfo.this.activeScalingTypes.containsKey((Object)type)) {
                            PlayerInfo.this.activeScalingTypes.put(type, 0.0);
                        }
                        return;
                    }
                    PlayerInfo.this.activeScalingTypes.put(type, event.getAmount());
                    if (PlayerInfo.this.getSkill().getConfigName().equals("eidolon") && PlayerInfo.this.activeScalingTypes.get((Object)type) >= PlayerInfo.this.getSkill().getScaling(PlayerInfo.this.getPlayer(), ScalingType.ENERGY)) {
                        EidolonImbalanceChangeEvent eicevent = new EidolonImbalanceChangeEvent(PlayerInfo.this.getPlayer(), EidolonForm.DARK, PlayerInfo.this.form);
                        if (PlayerInfo.this.form == EidolonForm.DARK) {
                            eicevent = new EidolonImbalanceChangeEvent(PlayerInfo.this.getPlayer(), EidolonForm.LIGHT, PlayerInfo.this.form);
                        }
                        EidolonImbalanceChangeEvent feicevent = eicevent;
                        Bukkit.getPluginManager().callEvent((Event)feicevent);
                        PlayerInfo.this.form = feicevent.getNewForm();
                        PlayerInfo.this.activeScalingTypes.put(type, 0.0);
                    }
                }
            }.runTask((Plugin)Skills.get());
        }
    }

    public boolean showReadyMessages() {
        return this.showReadyMessages;
    }

    public void setShowReadyMessages(boolean showReadyMessages) {
        this.showReadyMessages = showReadyMessages;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasSkill() {
        return !this.getSkill().getConfigName().equals("none");
    }

    public SkillType getSkill() {
        SkillType skill = Skills.get().getSkillTypeManager().getSkilltypes().get(this.skill.toLowerCase());
        return skill;
    }

    public int getLevel() {
        return this.level;
    }

    public int getExp() {
        return this.exp;
    }

    public int getSouls() {
        return this.souls;
    }

    public int getStatstr() {
        return this.statstr;
    }

    public int getStatint() {
        return this.statint;
    }

    public int getStatdex() {
        return this.statdex;
    }

    public int getStatdef() {
        return this.statdef;
    }

    public int getStatpoints() {
        return this.statpoints;
    }

    public String getImprovementstr() {
        return this.improvementstr;
    }

    public String getMasteriesstr() {
        return this.masteriesstr;
    }

    public int getMasteryLevel(Mastery mastery) {
        String masteryline = this.getMasteriesstr();
        if (masteryline == null) {
            return 0;
        }
        String[] split = masteryline.split(",");
        try {
            return Integer.parseInt(split[mastery.getTag()]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            masteryline = String.valueOf(masteryline) + ",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0";
            this.setMasteriesstr(masteryline);
            return Integer.parseInt(split[mastery.getTag()]);
        }
    }

    public void upgradeMastery(Mastery mastery, int amount) {
        String masteryline = this.getMasteriesstr();
        String[] split = masteryline.split(",");
        int level = Integer.parseInt(split[mastery.getTag()]);
        split[mastery.getTag()] = "" + (level + 1);
        String newline = "";
        int i = 0;
        while (i < split.length) {
            String s = split[i];
            newline = String.valueOf(newline) + s;
            if (i < split.length - 1) {
                newline = String.valueOf(newline) + ",";
            }
            ++i;
        }
        this.setMasteriesstr(newline);
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public ArrayList<Ability> getDisabledAbilities() {
        return this.disabledAbilities;
    }

    public void setDisabledAbilities(ArrayList<Ability> disabledAbilities) {
        this.disabledAbilities = disabledAbilities;
    }

    public boolean isActiveReady() {
        return this.activeReady;
    }

    public void setActiveReady(boolean activeReady) {
        if (this.activeReady != activeReady) {
            SkillActiveStateChangeEvent event = new SkillActiveStateChangeEvent(this.getPlayer(), activeReady);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        this.activeReady = activeReady;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSkill(SkillType skill) {
        this.skill = skill.getConfigName();
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setExp(int exp) {
        int needed = PlayerInfo.getLevelUpXpForLevel(this.getLevel());
        if (exp > needed) {
            this.levelUp(1);
            this.setExp(exp -= needed);
        } else {
            this.exp = exp;
        }
    }

    public double getScalingType(ScalingType type) {
        return this.getSkill().getScaling(this.getPlayer(), type);
    }

    public void levelUp(int levels) {
        if (levels == 0) {
            return;
        }
        int up = 1;
        while (up <= levels) {
            SkillLevelUpEvent event = new SkillLevelUpEvent(this.getOfflinePlayer(), this.getLevel(), this.getLevel() + 1);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            ++this.level;
            ++up;
        }
        this.exp = 0;
    }

    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public EidolonForm getForm() {
        return this.form;
    }

    public void setForm(EidolonForm form) {
        this.form = form;
    }

    public static int getLevelUpXpForLevel(int level) {
        String eqn = SkillsConfig.ConfigOption.LEVEL_REQUIREMENT_EQN.getString();
        int needed = (int)MathUtil.evaluateEquation(eqn.replaceAll("currlevel", String.valueOf(level)));
        if (needed < 1) {
            needed = 1;
        }
        return needed;
    }

    public void setSouls(int souls) {
        this.souls = souls;
    }

    public void setStatstr(int statstr) {
        this.statstr = statstr;
    }

    public void setStatint(int statint) {
        this.statint = statint;
    }

    public void setStatdex(int statdex) {
        this.statdex = statdex;
    }

    public void setStatdef(int statdef) {
        this.statdef = statdef;
    }

    public void toggleDisabled(Ability ab) {
        boolean toggle = false;
        if (this.disabledAbilities.contains(ab)) {
            this.disabledAbilities.remove(ab);
        } else {
            this.disabledAbilities.add(ab);
            toggle = true;
        }
        SkillToggleDisableEvent event = new SkillToggleDisableEvent(this.getOfflinePlayer(), ab, toggle);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public boolean isDisabled(Ability ab) {
        return this.disabledAbilities.contains(ab);
    }

    public BonusType getBonusType(SkillsEvent.SkillsEventType type) {
        for (BonusType bonus : this.getBonusList()) {
            if (bonus.getType() != type) continue;
            return bonus;
        }
        return null;
    }

    public ArrayList<BonusType> getBonusList() {
        ArrayList<BonusType> list = new ArrayList<BonusType>();
        for (String entry : this.bonusList) {
            String[] split = entry.split(":");
            SkillsEvent.SkillsEventType type = SkillsEvent.SkillsEventType.fromString(split[0]);
            long startTime = Long.parseLong(split[1]);
            int durationInSeconds = Integer.parseInt(split[2]);
            String multiplier = split[3];
            BonusType bonusType = new BonusType(this.getUuid(), type, multiplier, durationInSeconds, startTime);
            list.add(bonusType);
        }
        return list;
    }

    public void stopBonuses() {
        this.bonusList.clear();
    }

    public void addBonus(BonusType bonusType) {
        Iterator<String> it = this.bonusList.iterator();
        while (it.hasNext()) {
            String entry = it.next();
            if (!entry.startsWith(bonusType.getType().toString())) continue;
            it.remove();
        }
        String type = bonusType.getType().toString();
        String startTime = "" + bonusType.getStart();
        String duration = "" + bonusType.getTimeInSeconds();
        String multiplier = bonusType.getMultiplier();
        String entry = String.valueOf(type) + ":" + startTime + ":" + duration + ":" + multiplier;
        this.bonusList.add(entry);
    }

    public void purgeBonuses() {
        ArrayList expired = new ArrayList();
        for (BonusType type : this.getBonusList()) {
            if (type.isActive()) continue;
            for (String bonus : this.bonusList) {
                Iterator<String> it = this.bonusList.iterator();
                while (it.hasNext()) {
                    String entry = it.next();
                    if (!entry.startsWith(type.getType().toString())) continue;
                    it.remove();
                }
            }
        }
    }

    public int getSkillImprovementLevel(Ability ab) {
        try {
            return Integer.parseInt(this.improvementstr.split(",")[ab.saveIndex]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.improvementstr = String.valueOf(this.improvementstr) + ",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0";
            return Integer.parseInt(this.improvementstr.split(",")[ab.saveIndex]);
        }
    }

    public int getSkillImprovementLevel(Class clazz) {
        Ability[] abilityArray = this.getSkill().getAbilities();
        int n = abilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ability ab = abilityArray[n2];
            if (clazz.isInstance(ab)) {
                return this.getSkillImprovementLevel(ab);
            }
            ++n2;
        }
        return -1;
    }

    public Ability getSkillImprovement(Class clazz) {
        Ability[] abilityArray = this.getSkill().getAbilities();
        int n = abilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ability ab = abilityArray[n2];
            if (clazz.isInstance(ab)) {
                return ab;
            }
            ++n2;
        }
        return null;
    }

    public double getAbilityScaling(Class clazz) {
        return this.getSkillImprovement(clazz).getScaling(this);
    }

    public double getAbilityScaling(String string, Ability ab) {
        String finalEquation = string.replaceAll("int", "" + this.getStatint()).replaceAll("str", "" + this.getStatstr()).replaceAll("def", "" + this.getStatdef()).replaceAll("dex", "" + this.getStatdex()).replaceAll("lvl", "" + this.getSkillImprovementLevel(ab));
        return MathUtil.evaluateEquation(finalEquation);
    }

    public void upgradeSkillImprovement(Ability ab) {
        String improvementline = this.getImprovementstr();
        String[] split = improvementline.split(",");
        int level = Integer.parseInt(split[ab.saveIndex]);
        split[ab.saveIndex] = "" + (level + 1);
        String newline = "";
        int i = 0;
        while (i < split.length) {
            String s = split[i];
            newline = String.valueOf(newline) + s;
            if (i < split.length - 1) {
                newline = String.valueOf(newline) + ",";
            }
            ++i;
        }
        this.setImprovementstr(newline);
        SkillImproveEvent event = new SkillImproveEvent((OfflinePlayer)this.getPlayer(), ab);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public int getStat(StatType type) {
        switch (type) {
            case DEF: {
                return this.statdef;
            }
            case DEX: {
                return this.statdex;
            }
            case INT: {
                return this.statint;
            }
            case POINTS: {
                return this.statpoints;
            }
            case STR: {
                return this.statstr;
            }
        }
        return 0;
    }

    public void setStat(StatType type, int amt) {
        switch (type) {
            case DEF: {
                this.statdef = amt;
                break;
            }
            case DEX: {
                this.statdex = amt;
                break;
            }
            case INT: {
                this.statint = amt;
                break;
            }
            case POINTS: {
                this.statpoints = amt;
                break;
            }
            case STR: {
                this.statstr = amt;
            }
        }
    }

    public void resetStats() {
        Skills plugin = Skills.get();
        int statsToReturn = this.getStat(StatType.POINTS);
        statsToReturn += this.getStat(StatType.STR);
        statsToReturn += this.getStat(StatType.DEF);
        statsToReturn += this.getStat(StatType.DEX);
        this.setStat(StatType.POINTS, statsToReturn += this.getStat(StatType.INT));
        this.setStat(StatType.STR, 0);
        this.setStat(StatType.DEX, 0);
        this.setStat(StatType.DEF, 0);
        this.setStat(StatType.INT, 0);
    }

    public void setStatpoints(int statpoints) {
        this.statpoints = statpoints;
    }

    public void setImprovementstr(String improvementstr) {
        this.improvementstr = improvementstr;
    }

    public void setMasteriesstr(String masteriesstr) {
        this.masteriesstr = masteriesstr;
    }
}

