/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.database.managers;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.leothepro555.skills.database.SkillsDatabase;
import me.leothepro555.skills.database.SkillsDatabaseFile;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.external.ExternalHandler;
import me.leothepro555.skills.main.Skills;
import me.leothepro555.skills.main.SkillsConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerDataManager {
    public static HashMap<UUID, Integer> levels = new HashMap();
    public static Map<UUID, PlayerInfo> loadedPlayers = new ConcurrentHashMap<UUID, PlayerInfo>();
    public static final File FILEPATH = new File(Skills.get().getDataFolder(), "players");
    private Skills plugin;
    private static SkillsDatabase db;
    private boolean isSaving = false;

    public PlayerDataManager(Skills plugin) {
        this.plugin = plugin;
        if (!FILEPATH.exists()) {
            FILEPATH.mkdirs();
        }
        db = new SkillsDatabaseFile(FILEPATH);
        levels = this.getAllLevels();
        new Thread(new AutoSaveTask()).start();
    }

    public UUID[] getTop10UUIDs() {
        Integer[] highestLevels = new Integer[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        HashMap clone = (HashMap)levels.clone();
        Iterator iterator = clone.values().iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            int i = 0;
            while (i < 10) {
                if (highestLevels[i] < level) {
                    highestLevels[i] = level;
                    break;
                }
                ++i;
            }
            String debug = "";
            int i2 = 0;
            while (i2 < 10) {
                debug = String.valueOf(debug) + highestLevels[i2] + ",";
                ++i2;
            }
            Skills.logDebug(debug);
        }
        UUID[] topUUIDs = new UUID[10];
        int i = 0;
        while (i < 10) {
            if (highestLevels[i] == -1) break;
            UUID found = null;
            for (UUID id : clone.keySet()) {
                if (clone.get(id) != highestLevels[i]) continue;
                found = id;
                break;
            }
            clone.remove(found);
            topUUIDs[i] = found;
            ++i;
        }
        return topUUIDs;
    }

    private int getLevelOf(HashMap<UUID, Integer> levels, UUID id) {
        if (id == null) {
            return -1;
        }
        return levels.get(id);
    }

    public HashMap<UUID, Integer> getAllLevels() {
        HashMap<UUID, Integer> levels = new HashMap<UUID, Integer>();
        Set<String> keys = db.getAllKeys();
        if (keys.isEmpty()) {
            return levels;
        }
        for (String key : keys) {
            PlayerInfo info = (PlayerInfo)db.loadData(key, PlayerInfo.class);
            if (info == null) continue;
            levels.put(info.getUuid(), info.getLevel());
        }
        return levels;
    }

    public PlayerInfo loadPlayerInfo(OfflinePlayer p) {
        PlayerInfo info = null;
        if (loadedPlayers.containsKey(p.getUniqueId())) {
            db.saveData(p.getUniqueId().toString(), loadedPlayers.get(p.getUniqueId()));
            this.removeFromList(p.getUniqueId());
        }
        if ((info = (PlayerInfo)db.loadData(p.getUniqueId().toString(), PlayerInfo.class)) != null) {
            if (info.getImprovementstr().split(",").length < 63) {
                info.setImprovementstr(String.valueOf(info.getImprovementstr()) + ",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
            }
            this.addToList(p.getUniqueId(), info);
        } else {
            info = this.createPlayerInformation(p);
            this.addToList(p.getUniqueId(), info);
        }
        return info;
    }

    public PlayerInfo createPlayerInformation(OfflinePlayer p) {
        String uuid = p.getUniqueId().toString();
        PlayerInfo info = new PlayerInfo();
        info.setId(p.getName());
        info.setUuid(p.getUniqueId());
        info.setSkill(this.plugin.getSkillTypeManager().getSkilltypes().get("none"));
        info.level = 0;
        info.exp = 0;
        info.souls = 0;
        info.setStatstr(0);
        info.setStatdex(0);
        info.setStatint(0);
        info.setStatdef(0);
        info.setStatpoints(0);
        info.setImprovementstr("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
        info.setMasteriesstr("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
        return info;
    }

    public PlayerInfo createPlayerInformation() {
        UUID id = UUID.randomUUID();
        PlayerInfo info = new PlayerInfo();
        info.setId(id.toString());
        info.setUuid(id);
        info.setSkill(this.plugin.getSkillTypeManager().getSkilltypes().get("none"));
        info.level = 0;
        info.exp = 0;
        info.souls = 0;
        info.setStatstr(0);
        info.setStatdex(0);
        info.setStatint(0);
        info.setStatdef(0);
        info.setStatpoints(0);
        info.setImprovementstr("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
        info.setMasteriesstr("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");
        return info;
    }

    public void resetPlayerInformation(OfflinePlayer p) {
        PlayerInfo info = this.createPlayerInformation(p);
        this.addToList(p.getUniqueId(), info);
        if (p.isOnline()) {
            this.plugin.getHealthAndEnergyManager().setUpStats((Player)p);
        }
    }

    public PlayerInfo getOrLoadPlayerInfo(OfflinePlayer p) {
        if (p == null) {
            Skills.logDebug("Anomaly detected: Null player.");
            return this.createPlayerInformation();
        }
        if (loadedPlayers.containsKey(p.getUniqueId())) {
            return loadedPlayers.get(p.getUniqueId());
        }
        if (p instanceof Player && ExternalHandler.isCitizen((Entity)((Player)p))) {
            return this.createPlayerInformation(p);
        }
        PlayerInfo info = this.loadPlayerInfo(p);
        if (p.isOnline() && info != null) {
            Player online = (Player)p;
            if (this.plugin.getHealthAndEnergyManager() != null) {
                this.plugin.getHealthAndEnergyManager().setUpStats(online, info);
            }
        }
        return info;
    }

    public void addToList(UUID uuid, PlayerInfo info) {
        while (this.isSaving) {
            Skills.logDebug("Waiting for save to finish...");
        }
        loadedPlayers.put(uuid, info);
    }

    public void removeFromList(UUID uuid) {
        while (this.isSaving) {
            Skills.logDebug("Waiting for save to finish...");
        }
        loadedPlayers.remove(uuid);
    }

    public void saveAll() {
        this.isSaving = true;
        for (Map.Entry<UUID, PlayerInfo> entry : loadedPlayers.entrySet()) {
            String uuid = entry.getKey().toString();
            PlayerInfo pinfo = entry.getValue();
            db.saveData(uuid, pinfo);
        }
        this.isSaving = false;
    }

    private class AutoSaveTask
    implements Runnable {
        private AutoSaveTask() {
        }

        @Override
        public void run() {
            while (Skills.get().isEnabled()) {
                try {
                    Thread.sleep(SkillsConfig.ConfigOption.PLAYERDATA_SAVE_INTERVAL_SECONDS.getInt());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                PlayerDataManager.this.saveAll();
            }
        }
    }
}

