/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.database;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import me.leothepro555.skills.database.Data;
import me.leothepro555.skills.database.SkillsDatabase;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.database.managers.PlayerInfoSerializer;

public class SkillsDatabaseFile
extends SkillsDatabase {
    protected File dbFolder = null;

    public SkillsDatabaseFile(File dbFolder) {
        this.dbFolder = dbFolder;
        if (!this.dbFolder.exists()) {
            this.dbFolder.mkdirs();
        }
        SkillsDatabaseFile.register(PlayerInfo.class, new PlayerInfoSerializer());
    }

    @Override
    public synchronized boolean saveData(String key, Data data) {
        File file = new File(this.dbFolder, key);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (data != null) {
            try {
                String ser = (String)SkillsDatabaseFile.serialize(data);
                FileWriter fw = new FileWriter(file);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(ser);
                bw.close();
                fw.close();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            file.delete();
        }
        return false;
    }

    @Override
    public synchronized Data loadData(String key, Class<? extends Data> clazz) {
        File file = new File(this.dbFolder, key);
        if (!file.exists()) {
            return null;
        }
        String ser = "";
        try {
            String buffer;
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            while ((buffer = br.readLine()) != null) {
                ser = String.valueOf(ser) + buffer;
            }
            br.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Data data = SkillsDatabaseFile.deserialize(ser, clazz);
            return data;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasData(String key) {
        return this.getAllKeys().contains(key);
    }

    @Override
    public Set<String> getAllKeys() {
        HashSet<String> keys = new HashSet<String>();
        File[] fileArray = this.dbFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            keys.add(file.getName());
            ++n2;
        }
        return keys;
    }
}

