/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.database;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.leothepro555.skills.database.Data;
import me.leothepro555.skills.database.SkillsDBSerializer;

public abstract class SkillsDatabase {
    static final Map<Class<?>, SkillsDBSerializer<?>> registeredClasses = new HashMap();

    public abstract boolean saveData(String var1, Data var2);

    public abstract Data loadData(String var1, Class<? extends Data> var2);

    public abstract boolean hasData(String var1);

    public abstract Set<String> getAllKeys();

    protected static void register(Class<?> clazz, SkillsDBSerializer<?> serializer) {
        registeredClasses.put(clazz, serializer);
    }

    protected static Object serialize(Data data) throws ClassNotFoundException {
        if (!registeredClasses.containsKey(data.getClass())) {
            throw new ClassNotFoundException("couldn't found serializer for class " + data.getClass().getName());
        }
        SkillsDBSerializer<?> serializer = registeredClasses.get(data.getClass());
        return serializer.serialize(data);
    }

    protected static Data deserialize(Object data, Class<? extends Data> clazz) throws ClassNotFoundException {
        if (!registeredClasses.containsKey(clazz)) {
            throw new ClassNotFoundException("couldn't found serializer for class " + clazz.getName());
        }
        SkillsDBSerializer<?> serializer = registeredClasses.get(clazz);
        return (Data)serializer.deserialize(data);
    }
}

