/*
 * Decompiled with CFR 0.152.
 */
package me.leothepro555.skills.damage;

import java.util.ArrayList;
import java.util.UUID;
import me.leothepro555.skills.main.Skills;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class LastHitManager {
    public static final String hitMeta = "SKILLS_ATTACK_META";
    public static ArrayList<UUID> skillsAttacking = new ArrayList();

    public static void damageLivingEntityDirect(LivingEntity target, Player damager, double damage) {
        if (damager == null) {
            return;
        }
        if (!damager.isValid() || damager.isDead()) {
            return;
        }
        skillsAttacking.add(damager.getUniqueId());
        target.damage(damage);
        skillsAttacking.remove(damager.getUniqueId());
        target.setMetadata(hitMeta, (MetadataValue)new FixedMetadataValue((Plugin)Skills.get(), (Object)damager.getUniqueId().toString()));
    }

    public static void damageLivingEntity(LivingEntity target, Player damager, double damage) {
        if (damager == null) {
            return;
        }
        if (target == null) {
            return;
        }
        if (!damager.isValid() || damager.isDead()) {
            return;
        }
        if (!target.isValid() || target.isDead()) {
            return;
        }
        Vector v = target.getVelocity();
        skillsAttacking.add(damager.getUniqueId());
        target.damage(damage, (Entity)damager);
        target.setVelocity(v);
        skillsAttacking.remove(damager.getUniqueId());
    }

    public static Player getFinalHitMob(LivingEntity entity) {
        Player p;
        if (entity.getKiller() != null) {
            return entity.getKiller();
        }
        if (entity.hasMetadata(hitMeta) && (p = Bukkit.getPlayer((UUID)UUID.fromString(((MetadataValue)entity.getMetadata(hitMeta).get(0)).asString()))) != null) {
            return p;
        }
        return null;
    }
}

